/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.apachehttpdlog;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import nl.basjes.hadoop.input.ParsedRecord;
import nl.basjes.parse.apachehttpdlog.ApacheHttpdLoglineParser;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import nl.basjes.parse.core.exceptions.MissingDissectorsException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.AbstractDeserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpdlogDeserializer
extends AbstractDeserializer {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheHttpdlogDeserializer.class);
    private static final String FIELD = "field:";
    private static final String MAP_FIELD = "map:";
    private static final int MAP_FIELD_LENGTH = "map:".length();
    private static final String LOAD_DISSECTOR = "load:";
    private static final int LOAD_DISSECTOR_LENGTH = "load:".length();
    private StructObjectInspector rowOI;
    private ArrayList<Object> row;
    private ApacheHttpdLoglineParser<ParsedRecord> parser;
    private ParsedRecord currentValue;
    private static final long MINIMAL_FAIL_LINES = 1000L;
    private static final int MINIMAL_FAIL_PERCENTAGE = 1;
    private long linesInput = 0L;
    private long linesBad = 0L;
    private final List<ColumnToGetterMapping> columnToGetterMappings = new ArrayList<ColumnToGetterMapping>();

    public void initialize(Configuration conf, Properties props) throws SerDeException {
        boolean usable = true;
        this.linesInput = 0L;
        this.linesBad = 0L;
        String logformat = props.getProperty("logformat");
        HashMap<String, HashSet<String>> typeRemappings = new HashMap<String, HashSet<String>>();
        ArrayList<Dissector> additionalDissectors = new ArrayList<Dissector>();
        for (Map.Entry<Object, Object> property : props.entrySet()) {
            String key = (String)property.getKey();
            if (key.startsWith(MAP_FIELD)) {
                String mapField = key.substring(MAP_FIELD_LENGTH);
                String mapType = (String)property.getValue();
                HashSet<String> remapping = (HashSet<String>)typeRemappings.get(mapField);
                if (remapping == null) {
                    remapping = new HashSet<String>();
                    typeRemappings.put(mapField, remapping);
                }
                remapping.add(mapType);
                LOG.info("Add mapping for field \"{}\" to type \"{}\"", (Object)mapField, (Object)mapType);
                continue;
            }
            if (!key.startsWith(LOAD_DISSECTOR)) continue;
            String dissectorClassName = key.substring(LOAD_DISSECTOR_LENGTH);
            String dissectorParam = (String)property.getValue();
            try {
                Class<?> clazz = Class.forName(dissectorClassName);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                Dissector instance = (Dissector)constructor.newInstance(new Object[0]);
                instance.initializeFromSettingsParameter(dissectorParam);
                additionalDissectors.add(instance);
            }
            catch (ClassNotFoundException e) {
                throw new SerDeException("Found load with bad specification: No such class:" + dissectorClassName, (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new SerDeException("Found load with bad specification: Class does not have the required constructor", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new SerDeException("Got an InvocationTargetException", (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new SerDeException("Got an InstantiationException", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new SerDeException("Found load with bad specification: Required constructor is not public", (Throwable)e);
            }
            LOG.debug("Loaded additional dissector: {}(\"{}\")", (Object)dissectorClassName, (Object)dissectorParam);
        }
        this.currentValue = new ParsedRecord();
        String columnNameProperty = props.getProperty("columns");
        String columnTypeProperty = props.getProperty("columns.types");
        List<String> columnNames = Arrays.asList(columnNameProperty.split(","));
        ArrayList columnTypes = TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        assert (columnNames.size() == columnTypes.size());
        int numColumns = columnNames.size();
        this.parser = new ApacheHttpdLoglineParser(ParsedRecord.class, logformat);
        this.parser.setTypeRemappings(typeRemappings);
        this.parser.addDissectors(additionalDissectors);
        ArrayList<ObjectInspector> columnOIs = new ArrayList<ObjectInspector>(columnNames.size());
        try {
            for (int columnNr = 0; columnNr < numColumns; ++columnNr) {
                columnOIs.add(TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)((TypeInfo)columnTypes.get(columnNr))));
                String columnName = columnNames.get(columnNr);
                TypeInfo columnType = (TypeInfo)columnTypes.get(columnNr);
                String fieldValue = props.getProperty(FIELD + columnName);
                if (fieldValue == null) {
                    LOG.error("MUST have Field value for column \"{}\".", (Object)columnName);
                    usable = false;
                    continue;
                }
                ColumnToGetterMapping ctgm = new ColumnToGetterMapping();
                ctgm.index = columnNr;
                ctgm.fieldValue = fieldValue;
                ArrayList<String> singleFieldValue = new ArrayList<String>();
                singleFieldValue.add(fieldValue);
                switch (columnType.getTypeName()) {
                    case "string": {
                        ctgm.casts = Casts.STRING;
                        this.parser.addParseTarget(ParsedRecord.class.getMethod("set", String.class, String.class), singleFieldValue);
                        break;
                    }
                    case "bigint": {
                        ctgm.casts = Casts.LONG;
                        this.parser.addParseTarget(ParsedRecord.class.getMethod("set", String.class, Long.class), singleFieldValue);
                        break;
                    }
                    case "double": {
                        ctgm.casts = Casts.DOUBLE;
                        this.parser.addParseTarget(ParsedRecord.class.getMethod("set", String.class, Double.class), singleFieldValue);
                        break;
                    }
                    default: {
                        LOG.error("Requested column type {} is not supported at this time.", (Object)columnType.getTypeName());
                        usable = false;
                    }
                }
                this.columnToGetterMappings.add(ctgm);
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new SerDeException("(Should not occur) Caught exception: {}", (Throwable)e);
        }
        this.rowOI = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, columnOIs);
        this.row = new ArrayList(numColumns);
        for (int c = 0; c < numColumns; ++c) {
            this.row.add(null);
        }
        if (!usable) {
            throw new SerDeException("Fatal config error. Check the logged error messages why.");
        }
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.rowOI;
    }

    public Object deserialize(Writable writable) throws SerDeException {
        if (!(writable instanceof Text)) {
            throw new SerDeException("The input MUST be a Text line.");
        }
        ++this.linesInput;
        try {
            this.currentValue.clear();
            this.parser.parse((Object)this.currentValue, writable.toString());
        }
        catch (DissectionFailure dissectionFailure) {
            ++this.linesBad;
            if (this.linesInput >= 1000L && 100L * this.linesBad > 1L * this.linesInput) {
                throw new SerDeException("To many bad lines: " + this.linesBad + " of " + this.linesInput + " are bad.");
            }
            return null;
        }
        catch (InvalidDissectorException | MissingDissectorsException e) {
            throw new SerDeException("Cannot continue; Fix the Dissectors before retrying", e);
        }
        for (ColumnToGetterMapping ctgm : this.columnToGetterMappings) {
            switch (ctgm.casts) {
                case STRING: {
                    String currentValueString = this.currentValue.getString(ctgm.fieldValue);
                    this.row.set(ctgm.index, currentValueString);
                    break;
                }
                case LONG: {
                    Long currentValueLong = this.currentValue.getLong(ctgm.fieldValue);
                    this.row.set(ctgm.index, currentValueLong);
                    break;
                }
                case DOUBLE: {
                    Double currentValueDouble = this.currentValue.getDouble(ctgm.fieldValue);
                    this.row.set(ctgm.index, currentValueDouble);
                    break;
                }
            }
        }
        return this.row;
    }

    public SerDeStats getSerDeStats() {
        return new SerDeStats();
    }

    class ColumnToGetterMapping {
        private int index;
        private Casts casts;
        private String fieldValue;

        ColumnToGetterMapping() {
        }
    }
}

