/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.pig.input.apachehttpdlog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.hadoop.input.ApacheHttpdLogfileInputFormat;
import nl.basjes.hadoop.input.ApacheHttpdLogfileRecordReader;
import nl.basjes.hadoop.input.ParsedRecord;
import nl.basjes.parse.core.Casts;
import nl.basjes.pig.input.apachehttpdlog.IncorrectRecordReaderException;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.pig.Expression;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class Loader
extends LoadFunc
implements LoadMetadata {
    private ApacheHttpdLogfileRecordReader reader;
    private boolean isBuildingFields;
    private String logformat;
    private final List<String> requestedFields = new ArrayList<String>();
    private final TupleFactory tupleFactory;
    private ApacheHttpdLogfileInputFormat theInputFormat;

    public Loader(String ... parameters) {
        for (String param : parameters) {
            if (this.logformat == null) {
                this.logformat = param;
                continue;
            }
            this.requestedFields.add(param);
            this.isBuildingFields = this.isBuildingFields || "fields".equals(param.toLowerCase());
        }
        if (this.logformat == null) {
            throw new IllegalArgumentException("Must specify the logformat");
        }
        this.theInputFormat = new ApacheHttpdLogfileInputFormat(this.getLogformat(), this.getRequestedFields());
        this.reader = this.theInputFormat.getRecordReader();
        this.tupleFactory = TupleFactory.getInstance();
    }

    public InputFormat<?, ?> getInputFormat() throws IOException {
        return this.theInputFormat;
    }

    public String getLogformat() {
        return this.logformat;
    }

    public List<String> getRequestedFields() {
        return this.requestedFields;
    }

    public Tuple getNext() throws IOException {
        Tuple tuple = null;
        if (this.isBuildingFields) {
            this.isBuildingFields = false;
            return this.tupleFactory.newTuple((Object)this.createPigExample());
        }
        boolean notDone = this.reader.nextKeyValue();
        if (!notDone) {
            return null;
        }
        ParsedRecord value = (ParsedRecord)this.reader.getCurrentValue();
        if (value != null) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (String fieldName : this.requestedFields) {
                String theValue;
                EnumSet<Casts> casts = this.reader.getParser().getCasts(fieldName);
                if (casts != null) {
                    if (casts.contains((Object)Casts.LONG)) {
                        values.add(value.getLong(fieldName));
                        continue;
                    }
                    if (casts.contains((Object)Casts.DOUBLE)) {
                        values.add(value.getDouble(fieldName));
                        continue;
                    }
                }
                if ((theValue = value.getString(fieldName)) == null) {
                    values.add(null);
                    continue;
                }
                values.add(theValue);
            }
            tuple = this.tupleFactory.newTuple(values);
        }
        return tuple;
    }

    private String createPigExample() throws IOException {
        StringBuilder sb = new StringBuilder(1024);
        Text fieldName = new Text(this.requestedFields.get(0));
        ArrayList<String> fields = new ArrayList<String>(128);
        ArrayList<String> names = new ArrayList<String>(128);
        while (this.reader.nextKeyValue()) {
            MapWritable currentValue = this.reader.getCurrentValue();
            Writable value = currentValue.get((Object)fieldName);
            if (value == null) continue;
            if (value.toString().contains("*")) {
                fields.add(value.toString() + "', \t-- You cannot put a * here yet. You MUST specify a specific field.");
            } else {
                fields.add(value.toString());
            }
            String name = value.toString().split(":")[1].replace('.', '_');
            String nameComment = "";
            if (name.contains("*")) {
                nameComment = ", \t-- You cannot put a * here yet. You MUST specify name.";
            }
            EnumSet<Casts> casts = this.reader.getCasts(value.toString());
            String cast = "bytearray";
            if (casts != null) {
                if (casts.contains((Object)Casts.LONG)) {
                    cast = "long";
                } else if (casts.contains((Object)Casts.DOUBLE)) {
                    cast = "double";
                } else if (casts.contains((Object)Casts.STRING)) {
                    cast = "chararray";
                }
                names.add(name + ':' + cast + nameComment);
                continue;
            }
            names.add(name + nameComment);
        }
        return sb.append("\n").append("\n").append("\n").append("Clicks =\n").append("    LOAD 'access.log'\n").append("    USING ").append(((Object)((Object)this)).getClass().getCanonicalName()).append("(\n").append("    '").append(this.logformat).append("',\n").append('\n').append("        '").append(Loader.join(fields, (String)"',\n        '")).append("')\n").append("    AS (\n").append("        ").append(Loader.join(names, (String)",\n        ")).append(");\n").append("\n").append("\n").append("\n").toString();
    }

    public void prepareToRead(RecordReader newReader, PigSplit pigSplit) throws IOException {
        if (!(newReader instanceof ApacheHttpdLogfileRecordReader)) {
            throw new IncorrectRecordReaderException();
        }
        this.reader = (ApacheHttpdLogfileRecordReader)newReader;
    }

    public void setLocation(String location, Job job) throws IOException {
        FileInputFormat.setInputPaths((Job)job, (String)location);
    }

    public ResourceSchema getSchema(String location, Job job) throws IOException {
        ResourceSchema rs = new ResourceSchema();
        ArrayList<ResourceSchema.ResourceFieldSchema> fieldSchemaList = new ArrayList<ResourceSchema.ResourceFieldSchema>();
        for (String fieldName : this.requestedFields) {
            ResourceSchema.ResourceFieldSchema rfs = new ResourceSchema.ResourceFieldSchema();
            rfs.setName(fieldName);
            rfs.setDescription(fieldName);
            EnumSet<Casts> casts = this.theInputFormat.getRecordReader().getCasts(fieldName);
            if (casts != null) {
                if (casts.contains((Object)Casts.LONG)) {
                    rfs.setType((byte)15);
                } else if (casts.contains((Object)Casts.DOUBLE)) {
                    rfs.setType((byte)25);
                } else {
                    rfs.setType((byte)55);
                }
            } else {
                rfs.setType((byte)50);
            }
            fieldSchemaList.add(rfs);
        }
        rs.setFields(fieldSchemaList.toArray(new ResourceSchema.ResourceFieldSchema[fieldSchemaList.size()]));
        return rs;
    }

    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        return null;
    }

    public String[] getPartitionKeys(String location, Job job) throws IOException {
        return null;
    }

    public void setPartitionFilter(Expression partitionFilter) throws IOException {
    }
}

