/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.http.disectors;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import nl.basjes.parse.Utils;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Disector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DisectionFailure;

public class RequestCookieListDisector
extends Disector {
    private static final String INPUT_TYPE = "HTTP.COOKIES";
    private final Set<String> requestedCookies = new HashSet<String>(16);
    private final Pattern fieldSeparatorPattern = Pattern.compile("; ");

    @Override
    public String getInputType() {
        return INPUT_TYPE;
    }

    @Override
    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("HTTP.COOKIE:*");
        return result;
    }

    @Override
    protected void initializeNewInstance(Disector newInstance) {
    }

    @Override
    public EnumSet<Casts> prepareForDisect(String inputname, String outputname) {
        this.requestedCookies.add(outputname.substring(inputname.length() + 1));
        return Casts.STRING_ONLY;
    }

    @Override
    public void prepareForRun() {
    }

    @Override
    public void disect(Parsable<?> parsable, String inputname) throws DisectionFailure {
        String[] allValues;
        ParsedField field = parsable.getParsableField(INPUT_TYPE, inputname);
        String fieldValue = field.getValue();
        if (fieldValue == null || fieldValue.isEmpty()) {
            return;
        }
        for (String value : allValues = this.fieldSeparatorPattern.split(fieldValue)) {
            String theName;
            int equalPos = value.indexOf(61);
            if (equalPos == -1) {
                if ("".equals(value) || !this.requestedCookies.contains(theName = value.trim().toLowerCase())) continue;
                parsable.addDisection(inputname, this.getDisectionType(inputname, theName), theName, "");
                continue;
            }
            theName = value.substring(0, equalPos).trim().toLowerCase();
            if (!this.requestedCookies.contains(theName)) continue;
            String theValue = value.substring(equalPos + 1, value.length()).trim();
            try {
                parsable.addDisection(inputname, this.getDisectionType(inputname, theName), theName, Utils.resilientUrlDecode(theValue));
            }
            catch (IllegalArgumentException e) {
                throw new DisectionFailure(e.getMessage());
            }
        }
    }

    public String getDisectionType(String basename, String name) {
        return "HTTP.COOKIE";
    }
}

