/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.http.disectors;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.basjes.parse.Utils;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Disector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DisectionFailure;

public class QueryStringFieldDisector
extends Disector {
    private static final String INPUT_TYPE = "HTTP.QUERYSTRING";
    private final Set<String> requestedParameters = new HashSet<String>(16);

    @Override
    public String getInputType() {
        return INPUT_TYPE;
    }

    @Override
    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("STRING:*");
        return result;
    }

    @Override
    protected void initializeNewInstance(Disector newInstance) {
    }

    @Override
    public EnumSet<Casts> prepareForDisect(String inputname, String outputname) {
        this.requestedParameters.add(outputname.substring(inputname.length() + 1));
        return Casts.STRING_ONLY;
    }

    @Override
    public void prepareForRun() {
    }

    @Override
    public void disect(Parsable<?> parsable, String inputname) throws DisectionFailure {
        String[] allValues;
        ParsedField field = parsable.getParsableField(INPUT_TYPE, inputname);
        String fieldValue = field.getValue();
        if (fieldValue == null || fieldValue.isEmpty()) {
            return;
        }
        for (String value : allValues = fieldValue.split("&")) {
            String name;
            int equalPos = value.indexOf(61);
            if (equalPos == -1) {
                if ("".equals(value) || !this.requestedParameters.contains(name = value.toLowerCase())) continue;
                parsable.addDisection(inputname, this.getDisectionType(inputname, value), name, "");
                continue;
            }
            name = value.substring(0, equalPos).toLowerCase();
            if (!this.requestedParameters.contains(name)) continue;
            try {
                parsable.addDisection(inputname, this.getDisectionType(inputname, name), name, Utils.resilientUrlDecode(value.substring(equalPos + 1, value.length())));
            }
            catch (IllegalArgumentException e) {
                throw new DisectionFailure(e.getMessage());
            }
        }
    }

    public String getDisectionType(String basename, String name) {
        return "STRING";
    }
}

