/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.httpdlog.Utils;
import nl.basjes.parse.httpdlog.httpdlog-parser.shaded.org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.codec.net.URLCodec;

public class HttpUriDissector
extends Dissector {
    private static final String INPUT_TYPE = "HTTP.URI";
    private boolean wantProtocol = false;
    private boolean wantUserinfo = false;
    private boolean wantHost = false;
    private boolean wantPort = false;
    private boolean wantPath = false;
    private boolean wantQuery = false;
    private boolean wantRef = false;
    private static final BitSet BAD_URI_CHARS = new BitSet(256);
    private static final Pattern BAD_EXCAPE_PATTERN;
    private static final Pattern EQUALS_HASH_PATTERN;
    private static final Pattern HASH_AMP_PATTERN;
    private static final Pattern DOUBLE_HASH_PATTERN;
    private static final Pattern ALMOST_HTML_ENCODED;

    public String getInputType() {
        return INPUT_TYPE;
    }

    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("HTTP.PROTOCOL:protocol");
        result.add("HTTP.USERINFO:userinfo");
        result.add("HTTP.HOST:host");
        result.add("HTTP.PORT:port");
        result.add("HTTP.PATH:path");
        result.add("HTTP.QUERYSTRING:query");
        result.add("HTTP.REF:ref");
        return result;
    }

    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        String name = this.extractFieldName(inputname, outputname);
        if ("protocol".equals(name)) {
            this.wantProtocol = true;
            return Casts.STRING_ONLY;
        }
        if ("userinfo".equals(name)) {
            this.wantUserinfo = true;
            return Casts.STRING_ONLY;
        }
        if ("host".equals(name)) {
            this.wantHost = true;
            return Casts.STRING_ONLY;
        }
        if ("port".equals(name)) {
            this.wantPort = true;
            return Casts.STRING_OR_LONG;
        }
        if ("path".equals(name)) {
            this.wantPath = true;
            return Casts.STRING_ONLY;
        }
        if ("query".equals(name)) {
            this.wantQuery = true;
            return Casts.STRING_ONLY;
        }
        if ("ref".equals(name)) {
            this.wantRef = true;
            return Casts.STRING_ONLY;
        }
        return Casts.NO_CASTS;
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        String value;
        URI uri;
        Matcher doubleHashMatcher;
        ParsedField field = parsable.getParsableField(INPUT_TYPE, inputname);
        String uriString = field.getValue().getString();
        if (uriString == null || uriString.isEmpty()) {
            return;
        }
        uriString = new String(URLCodec.encodeUrl((BitSet)BAD_URI_CHARS, (byte[])uriString.getBytes(StandardCharsets.UTF_8)), StandardCharsets.US_ASCII);
        uriString = Utils.makeHTMLEncodedInert(uriString);
        int firstQuestionMark = uriString.indexOf(63);
        int firstAmpersand = uriString.indexOf(38);
        if (firstAmpersand != -1 || firstQuestionMark != -1) {
            uriString = uriString.replace("?", "&");
            uriString = uriString.replaceFirst("&", "?&");
        }
        uriString = BAD_EXCAPE_PATTERN.matcher(uriString).replaceAll("%25$1");
        uriString = BAD_EXCAPE_PATTERN.matcher(uriString).replaceAll("%25$1");
        uriString = ALMOST_HTML_ENCODED.matcher(uriString).replaceAll("$1&$2");
        uriString = StringEscapeUtils.unescapeHtml4(uriString);
        uriString = EQUALS_HASH_PATTERN.matcher(uriString).replaceAll("=");
        uriString = HASH_AMP_PATTERN.matcher(uriString).replaceAll("&");
        while ((doubleHashMatcher = DOUBLE_HASH_PATTERN.matcher(uriString)).find()) {
            uriString = doubleHashMatcher.replaceAll("~$1#");
        }
        boolean isUrl = true;
        try {
            if (uriString.charAt(0) == '/') {
                uri = URI.create("dummy-protocol://dummy.host.name" + uriString);
                isUrl = false;
            } else {
                uri = URI.create(uriString);
            }
        }
        catch (IllegalArgumentException e) {
            return;
        }
        if (this.wantQuery || this.wantPath || this.wantRef) {
            if (this.wantQuery && (value = uri.getRawQuery()) != null && !value.isEmpty()) {
                parsable.addDissection(inputname, "HTTP.QUERYSTRING", "query", value);
            }
            if (this.wantPath && (value = uri.getPath()) != null && !value.isEmpty()) {
                parsable.addDissection(inputname, "HTTP.PATH", "path", value);
            }
            if (this.wantRef && (value = uri.getFragment()) != null && !value.isEmpty()) {
                parsable.addDissection(inputname, "HTTP.REF", "ref", value);
            }
        }
        if (isUrl) {
            int value2;
            if (this.wantProtocol && (value = uri.getScheme()) != null && !value.isEmpty()) {
                parsable.addDissection(inputname, "HTTP.PROTOCOL", "protocol", value);
            }
            if (this.wantUserinfo && (value = uri.getUserInfo()) != null && !value.isEmpty()) {
                parsable.addDissection(inputname, "HTTP.USERINFO", "userinfo", value);
            }
            if (this.wantHost && (value = uri.getHost()) != null && !value.isEmpty()) {
                parsable.addDissection(inputname, "HTTP.HOST", "host", value);
            }
            if (this.wantPort && (value2 = uri.getPort()) != -1) {
                parsable.addDissection(inputname, "HTTP.PORT", "port", value2);
            }
        }
    }

    static {
        BAD_URI_CHARS.set(0, 255);
        BAD_URI_CHARS.clear(123);
        BAD_URI_CHARS.clear(125);
        BAD_URI_CHARS.clear(124);
        BAD_URI_CHARS.clear(92);
        BAD_URI_CHARS.clear(94);
        BAD_URI_CHARS.clear(91);
        BAD_URI_CHARS.clear(93);
        BAD_URI_CHARS.clear(96);
        BAD_URI_CHARS.clear(32);
        BAD_URI_CHARS.clear(0, 31);
        BAD_URI_CHARS.clear(127);
        BAD_URI_CHARS.clear(60);
        BAD_URI_CHARS.clear(62);
        BAD_URI_CHARS.clear(34);
        BAD_EXCAPE_PATTERN = Pattern.compile("%([^0-9a-fA-F]|[0-9a-fA-F][^0-9a-fA-F]|.$|$)");
        EQUALS_HASH_PATTERN = Pattern.compile("=#");
        HASH_AMP_PATTERN = Pattern.compile("#&");
        DOUBLE_HASH_PATTERN = Pattern.compile("#(.*)#");
        ALMOST_HTML_ENCODED = Pattern.compile("([^&])(#x[0-9a-fA-F][0-9a-fA-F];)");
    }
}

