/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog;

import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.httpdlog.HttpdLogFormatDissector;
import nl.basjes.parse.httpdlog.dissectors.HttpFirstLineDissector;
import nl.basjes.parse.httpdlog.dissectors.HttpFirstLineProtocolDissector;
import nl.basjes.parse.httpdlog.dissectors.HttpUriDissector;
import nl.basjes.parse.httpdlog.dissectors.ModUniqueIdDissector;
import nl.basjes.parse.httpdlog.dissectors.QueryStringFieldDissector;
import nl.basjes.parse.httpdlog.dissectors.RequestCookieListDissector;
import nl.basjes.parse.httpdlog.dissectors.ResponseSetCookieDissector;
import nl.basjes.parse.httpdlog.dissectors.ResponseSetCookieListDissector;
import nl.basjes.parse.httpdlog.dissectors.TimeStampDissector;
import nl.basjes.parse.httpdlog.dissectors.translate.ConvertCLFIntoNumber;
import nl.basjes.parse.httpdlog.dissectors.translate.ConvertNumberIntoCLF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpdLoglineParser<RECORD>
extends Parser<RECORD> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpdLoglineParser.class);

    public HttpdLoglineParser(Class<RECORD> clazz, String logformat) {
        super(clazz);
        HttpdLoglineParser.logVersion();
        this.setupDissectors(logformat, null);
    }

    public static void logVersion() {
        String[] lines = new String[]{"Apache HTTPD & NGINX Access log parsing made easy", "For more information: https://github.com/nielsbasjes/logparser", "Copyright (C) 2011-2021 Niels Basjes - License Apache 2.0"};
        String version = HttpdLoglineParser.getVersion();
        int width = version.length();
        for (String line : lines) {
            width = Math.max(width, line.length());
        }
        LOG.info("");
        LOG.info("/-{}-\\", (Object)HttpdLoglineParser.padding('-', width));
        HttpdLoglineParser.logLine(version, width);
        LOG.info("+-{}-+", (Object)HttpdLoglineParser.padding('-', width));
        for (String line : lines) {
            HttpdLoglineParser.logLine(line, width);
        }
        LOG.info("\\-{}-/", (Object)HttpdLoglineParser.padding('-', width));
        LOG.info("");
    }

    private static String padding(char letter, int count) {
        StringBuilder sb = new StringBuilder(128);
        for (int i = 0; i < count; ++i) {
            sb.append(letter);
        }
        return sb.toString();
    }

    private static void logLine(String line, int width) {
        LOG.info("| {}{} |", (Object)line, (Object)HttpdLoglineParser.padding(' ', width - line.length()));
    }

    public static String getVersion() {
        return "LogParser 5.8 (v5.8 @ 2022-05-05T15:37:02Z)";
    }

    public HttpdLoglineParser(Class<RECORD> clazz, String logformat, String timestampFormat) {
        super(clazz);
        this.setupDissectors(logformat, timestampFormat);
    }

    private void setupDissectors(String logformat, String timestampFormat) {
        this.addDissector(new HttpdLogFormatDissector(logformat));
        this.addDissector(new TimeStampDissector("TIME.STAMP", timestampFormat));
        this.addDissector(new TimeStampDissector("TIME.ISO8601", "yyyy-MM-dd'T'HH:mm:ssXXX"));
        this.addDissector(new HttpFirstLineDissector());
        this.addDissector(new HttpFirstLineProtocolDissector());
        this.addDissector(new HttpUriDissector());
        this.addDissector(new QueryStringFieldDissector());
        this.addDissector(new RequestCookieListDissector());
        this.addDissector(new ResponseSetCookieListDissector());
        this.addDissector(new ResponseSetCookieDissector());
        this.addDissector(new ModUniqueIdDissector());
        this.addDissector((Dissector)new ConvertCLFIntoNumber("BYTESCLF", "BYTES"));
        this.addDissector((Dissector)new ConvertNumberIntoCLF("BYTES", "BYTESCLF"));
        this.setRootType("HTTPLOGLINE");
    }
}

