/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.TextStyle;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DissectionFailure;

public class TimeStampDissector
extends Dissector {
    public static final String DEFAULT_APACHE_DATE_TIME_PATTERN = "dd/MMM/yyyy:HH:mm:ss ZZ";
    private transient DateTimeFormatter formatter;
    private String dateTimePattern;
    private Locale locale = Locale.UK;
    private String inputType = "TIME.STAMP";
    private boolean wantAnyAsParsed = false;
    private boolean wantAnyUTC = false;
    private boolean wantAnyTZIndependent = false;
    private boolean wantDay = false;
    private boolean wantMonthname = false;
    private boolean wantMonth = false;
    private boolean wantWeekOfWeekYear = false;
    private boolean wantWeekYear = false;
    private boolean wantYear = false;
    private boolean wantHour = false;
    private boolean wantMinute = false;
    private boolean wantSecond = false;
    private boolean wantMillisecond = false;
    private boolean wantMicrosecond = false;
    private boolean wantNanosecond = false;
    private boolean wantDate = false;
    private boolean wantTime = false;
    private boolean wantTimezone = false;
    private boolean wantEpoch = false;
    private boolean wantDayUTC = false;
    private boolean wantMonthnameUTC = false;
    private boolean wantMonthUTC = false;
    private boolean wantWeekOfWeekYearUTC = false;
    private boolean wantWeekYearUTC = false;
    private boolean wantYearUTC = false;
    private boolean wantHourUTC = false;
    private boolean wantMinuteUTC = false;
    private boolean wantSecondUTC = false;
    private boolean wantMillisecondUTC = false;
    private boolean wantMicrosecondUTC = false;
    private boolean wantNanosecondUTC = false;
    private boolean wantDateUTC = false;
    private boolean wantTimeUTC = false;
    private static final DateTimeFormatter ISO_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter ISO_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");

    public TimeStampDissector() {
        this(DEFAULT_APACHE_DATE_TIME_PATTERN);
    }

    public TimeStampDissector(String newDateTimePattern) {
        this("TIME.STAMP", newDateTimePattern);
    }

    public TimeStampDissector(String inputType, String newDateTimePattern) {
        this.setInputType(inputType);
        if (newDateTimePattern == null || newDateTimePattern.trim().isEmpty()) {
            this.setDateTimePattern(DEFAULT_APACHE_DATE_TIME_PATTERN);
        } else {
            this.setDateTimePattern(newDateTimePattern);
        }
    }

    public TimeStampDissector setLocale(Locale newLocale) {
        this.locale = newLocale;
        return this;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean initializeFromSettingsParameter(String settings) {
        this.setDateTimePattern(settings);
        return true;
    }

    public void setDateTimePattern(String nDateTimePattern) {
        this.dateTimePattern = nDateTimePattern;
    }

    protected void setFormatter(DateTimeFormatter newFormatter) {
        this.formatter = newFormatter;
    }

    protected DateTimeFormatter getFormatter() {
        if (this.formatter == null) {
            this.formatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern(this.dateTimePattern).toFormatter().withLocale(this.locale);
        }
        return this.formatter;
    }

    protected void initializeNewInstance(Dissector newInstance) {
        TimeStampDissector newTimeStampDissector = (TimeStampDissector)newInstance;
        newTimeStampDissector.setInputType(this.inputType);
        newTimeStampDissector.setDateTimePattern(this.dateTimePattern);
        newTimeStampDissector.setLocale(this.locale);
    }

    public String getInputType() {
        return this.inputType;
    }

    public final void setInputType(String nInputType) {
        this.inputType = nInputType;
    }

    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("TIME.DAY:day");
        result.add("TIME.MONTHNAME:monthname");
        result.add("TIME.MONTH:month");
        result.add("TIME.WEEK:weekofweekyear");
        result.add("TIME.YEAR:weekyear");
        result.add("TIME.YEAR:year");
        result.add("TIME.HOUR:hour");
        result.add("TIME.MINUTE:minute");
        result.add("TIME.SECOND:second");
        result.add("TIME.MILLISECOND:millisecond");
        result.add("TIME.MICROSECOND:microsecond");
        result.add("TIME.NANOSECOND:nanosecond");
        result.add("TIME.DATE:date");
        result.add("TIME.TIME:time");
        result.add("TIME.ZONE:timezone");
        result.add("TIME.EPOCH:epoch");
        result.add("TIME.DAY:day_utc");
        result.add("TIME.MONTHNAME:monthname_utc");
        result.add("TIME.MONTH:month_utc");
        result.add("TIME.WEEK:weekofweekyear_utc");
        result.add("TIME.YEAR:weekyear_utc");
        result.add("TIME.YEAR:year_utc");
        result.add("TIME.HOUR:hour_utc");
        result.add("TIME.MINUTE:minute_utc");
        result.add("TIME.SECOND:second_utc");
        result.add("TIME.MILLISECOND:millisecond_utc");
        result.add("TIME.MICROSECOND:microsecond_utc");
        result.add("TIME.NANOSECOND:nanosecond_utc");
        result.add("TIME.DATE:date_utc");
        result.add("TIME.TIME:time_utc");
        return result;
    }

    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        String name;
        switch (name = this.extractFieldName(inputname, outputname)) {
            case "day": {
                this.wantDay = true;
                return Casts.STRING_OR_LONG;
            }
            case "monthname": {
                this.wantMonthname = true;
                return Casts.STRING_ONLY;
            }
            case "month": {
                this.wantMonth = true;
                return Casts.STRING_OR_LONG;
            }
            case "weekofweekyear": {
                this.wantWeekOfWeekYear = true;
                return Casts.STRING_OR_LONG;
            }
            case "weekyear": {
                this.wantWeekYear = true;
                return Casts.STRING_OR_LONG;
            }
            case "year": {
                this.wantYear = true;
                return Casts.STRING_OR_LONG;
            }
            case "hour": {
                this.wantHour = true;
                return Casts.STRING_OR_LONG;
            }
            case "minute": {
                this.wantMinute = true;
                return Casts.STRING_OR_LONG;
            }
            case "second": {
                this.wantSecond = true;
                return Casts.STRING_OR_LONG;
            }
            case "millisecond": {
                this.wantMillisecond = true;
                return Casts.STRING_OR_LONG;
            }
            case "microsecond": {
                this.wantMicrosecond = true;
                return Casts.STRING_OR_LONG;
            }
            case "nanosecond": {
                this.wantNanosecond = true;
                return Casts.STRING_OR_LONG;
            }
            case "date": {
                this.wantDate = true;
                return Casts.STRING_ONLY;
            }
            case "time": {
                this.wantTime = true;
                return Casts.STRING_ONLY;
            }
            case "timezone": {
                this.wantTimezone = true;
                return Casts.STRING_ONLY;
            }
            case "epoch": {
                this.wantEpoch = true;
                return Casts.STRING_OR_LONG;
            }
            case "day_utc": {
                this.wantDayUTC = true;
                return Casts.STRING_OR_LONG;
            }
            case "monthname_utc": {
                this.wantMonthnameUTC = true;
                return Casts.STRING_ONLY;
            }
            case "month_utc": {
                this.wantMonthUTC = true;
                return Casts.STRING_OR_LONG;
            }
            case "weekofweekyear_utc": {
                this.wantWeekOfWeekYearUTC = true;
                return Casts.STRING_OR_LONG;
            }
            case "weekyear_utc": {
                this.wantWeekYearUTC = true;
                return Casts.STRING_OR_LONG;
            }
            case "year_utc": {
                this.wantYearUTC = true;
                return Casts.STRING_OR_LONG;
            }
            case "hour_utc": {
                this.wantHourUTC = true;
                return Casts.STRING_OR_LONG;
            }
            case "minute_utc": {
                this.wantMinuteUTC = true;
                return Casts.STRING_OR_LONG;
            }
            case "second_utc": {
                this.wantSecondUTC = true;
                return Casts.STRING_OR_LONG;
            }
            case "millisecond_utc": {
                this.wantMillisecondUTC = true;
                return Casts.STRING_OR_LONG;
            }
            case "microsecond_utc": {
                this.wantMicrosecondUTC = true;
                return Casts.STRING_OR_LONG;
            }
            case "nanosecond_utc": {
                this.wantNanosecondUTC = true;
                return Casts.STRING_OR_LONG;
            }
            case "date_utc": {
                this.wantDateUTC = true;
                return Casts.STRING_ONLY;
            }
            case "time_utc": {
                this.wantTimeUTC = true;
                return Casts.STRING_ONLY;
            }
        }
        return Casts.NO_CASTS;
    }

    public void prepareForRun() {
        this.wantAnyAsParsed = this.wantDay || this.wantMonthname || this.wantMonth || this.wantWeekOfWeekYear || this.wantWeekYear || this.wantYear || this.wantHour || this.wantMinute || this.wantSecond || this.wantMillisecond || this.wantMicrosecond || this.wantNanosecond || this.wantDate || this.wantTime;
        this.wantAnyTZIndependent = this.wantTimezone || this.wantEpoch;
        this.wantAnyUTC = this.wantDayUTC || this.wantMonthnameUTC || this.wantMonthUTC || this.wantWeekOfWeekYearUTC || this.wantWeekYearUTC || this.wantYearUTC || this.wantHourUTC || this.wantMinuteUTC || this.wantSecondUTC || this.wantMillisecondUTC || this.wantMicrosecondUTC || this.wantNanosecondUTC || this.wantDateUTC || this.wantTimeUTC;
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        ParsedField field = parsable.getParsableField(this.getInputType(), inputname);
        this.dissect(field, parsable, inputname);
    }

    protected void dissect(ParsedField field, Parsable<?> parsable, String inputname) throws DissectionFailure {
        ZonedDateTime dateTime;
        String fieldValue = field.getValue().getString();
        if (fieldValue == null || fieldValue.isEmpty()) {
            return;
        }
        try {
            dateTime = this.getFormatter().parse((CharSequence)fieldValue, ZonedDateTime::from);
        }
        catch (DateTimeParseException dtpe) {
            throw new DissectionFailure(dtpe.getMessage() + "\n          10        20        30        40        50        60        70        80        90        100       110       120\n_123456789_123456789_123456789_123456789_123456789_123456789_123456789_123456789_123456789_123456789_123456789_123456789_\n" + fieldValue + "\n\n" + this.formatter.toString(), (Throwable)dtpe);
        }
        if (this.wantAnyTZIndependent) {
            if (this.wantTimezone) {
                parsable.addDissection(inputname, "TIME.TIMEZONE", "timezone", dateTime.getZone().getDisplayName(TextStyle.FULL, this.locale));
            }
            if (this.wantEpoch) {
                parsable.addDissection(inputname, "TIME.EPOCH", "epoch", dateTime.toInstant().toEpochMilli());
            }
        }
        if (this.wantAnyAsParsed) {
            LocalDateTime localDateTime = dateTime.toLocalDateTime();
            if (this.wantDay) {
                parsable.addDissection(inputname, "TIME.DAY", "day", localDateTime.getDayOfMonth());
            }
            if (this.wantMonthname) {
                parsable.addDissection(inputname, "TIME.MONTHNAME", "monthname", localDateTime.getMonth().getDisplayName(TextStyle.FULL, this.locale));
            }
            if (this.wantMonth) {
                parsable.addDissection(inputname, "TIME.MONTH", "month", localDateTime.getMonth().getValue());
            }
            if (this.wantWeekOfWeekYear) {
                parsable.addDissection(inputname, "TIME.WEEK", "weekofweekyear", localDateTime.get(WeekFields.of(this.locale).weekOfWeekBasedYear()));
            }
            if (this.wantWeekYear) {
                parsable.addDissection(inputname, "TIME.YEAR", "weekyear", localDateTime.get(WeekFields.of(this.locale).weekBasedYear()));
            }
            if (this.wantYear) {
                parsable.addDissection(inputname, "TIME.YEAR", "year", localDateTime.getYear());
            }
            if (this.wantHour) {
                parsable.addDissection(inputname, "TIME.HOUR", "hour", localDateTime.getHour());
            }
            if (this.wantMinute) {
                parsable.addDissection(inputname, "TIME.MINUTE", "minute", localDateTime.getMinute());
            }
            if (this.wantSecond) {
                parsable.addDissection(inputname, "TIME.SECOND", "second", localDateTime.getSecond());
            }
            if (this.wantMillisecond) {
                parsable.addDissection(inputname, "TIME.MILLISECOND", "millisecond", (long)localDateTime.getNano() / 1000000L);
            }
            if (this.wantMicrosecond) {
                parsable.addDissection(inputname, "TIME.MICROSECOND", "microsecond", (long)localDateTime.getNano() / 1000L);
            }
            if (this.wantNanosecond) {
                parsable.addDissection(inputname, "TIME.NANOSECOND", "nanosecond", localDateTime.getNano());
            }
            if (this.wantDate) {
                parsable.addDissection(inputname, "TIME.DATE", "date", localDateTime.format(ISO_DATE_FORMATTER));
            }
            if (this.wantTime) {
                parsable.addDissection(inputname, "TIME.TIME", "time", localDateTime.format(ISO_TIME_FORMATTER));
            }
        }
        if (this.wantAnyUTC) {
            ZonedDateTime zonedDateTime = dateTime.withZoneSameInstant(ZoneOffset.UTC);
            if (this.wantDayUTC) {
                parsable.addDissection(inputname, "TIME.DAY", "day_utc", zonedDateTime.getDayOfMonth());
            }
            if (this.wantMonthnameUTC) {
                parsable.addDissection(inputname, "TIME.MONTHNAME", "monthname_utc", zonedDateTime.getMonth().getDisplayName(TextStyle.FULL, this.locale));
            }
            if (this.wantMonthUTC) {
                parsable.addDissection(inputname, "TIME.MONTH", "month_utc", zonedDateTime.getMonthValue());
            }
            if (this.wantWeekOfWeekYearUTC) {
                parsable.addDissection(inputname, "TIME.WEEK", "weekofweekyear_utc", zonedDateTime.get(WeekFields.ISO.weekOfWeekBasedYear()));
            }
            if (this.wantWeekYearUTC) {
                parsable.addDissection(inputname, "TIME.YEAR", "weekyear_utc", zonedDateTime.get(WeekFields.ISO.weekBasedYear()));
            }
            if (this.wantYearUTC) {
                parsable.addDissection(inputname, "TIME.YEAR", "year_utc", zonedDateTime.getYear());
            }
            if (this.wantHourUTC) {
                parsable.addDissection(inputname, "TIME.HOUR", "hour_utc", zonedDateTime.getHour());
            }
            if (this.wantMinuteUTC) {
                parsable.addDissection(inputname, "TIME.MINUTE", "minute_utc", zonedDateTime.getMinute());
            }
            if (this.wantSecondUTC) {
                parsable.addDissection(inputname, "TIME.SECOND", "second_utc", zonedDateTime.getSecond());
            }
            if (this.wantMillisecondUTC) {
                parsable.addDissection(inputname, "TIME.MILLISECOND", "millisecond_utc", (long)zonedDateTime.getNano() / 1000000L);
            }
            if (this.wantMicrosecondUTC) {
                parsable.addDissection(inputname, "TIME.MICROSECOND", "microsecond_utc", (long)zonedDateTime.getNano() / 1000L);
            }
            if (this.wantNanosecondUTC) {
                parsable.addDissection(inputname, "TIME.NANOSECOND", "nanosecond_utc", zonedDateTime.getNano());
            }
            if (this.wantDateUTC) {
                parsable.addDissection(inputname, "TIME.DATE", "date_utc", zonedDateTime.format(ISO_DATE_FORMATTER));
            }
            if (this.wantTimeUTC) {
                parsable.addDissection(inputname, "TIME.TIME", "time_utc", zonedDateTime.format(ISO_TIME_FORMATTER));
            }
        }
    }
}

