/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors.geoip;

import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.AsnResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.httpdlog.dissectors.geoip.AbstractGeoIPDissector;

public class GeoIPASNDissector
extends AbstractGeoIPDissector {
    private boolean wantAsnNumber = false;
    private boolean wantAsnOrganization = false;

    public GeoIPASNDissector() {
    }

    public GeoIPASNDissector(String databaseFileName) {
        super(databaseFileName);
    }

    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("ASN:asn.number");
        result.add("STRING:asn.organization");
        return result;
    }

    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        String name;
        switch (name = this.extractFieldName(inputname, outputname)) {
            case "asn.number": {
                this.wantAsnNumber = true;
                return Casts.STRING_OR_LONG;
            }
            case "asn.organization": {
                this.wantAsnOrganization = true;
                return Casts.STRING_ONLY;
            }
        }
        return null;
    }

    @Override
    public void dissect(Parsable<?> parsable, String inputname, InetAddress ipAddress) throws DissectionFailure {
        AsnResponse response;
        try {
            response = this.reader.asn(ipAddress);
        }
        catch (GeoIp2Exception | IOException e) {
            return;
        }
        if (response == null) {
            return;
        }
        this.extractAsnFields(parsable, inputname, response);
    }

    protected void extractAsnFields(Parsable<?> parsable, String inputname, AsnResponse response) throws DissectionFailure {
        if (this.wantAsnNumber) {
            parsable.addDissection(inputname, "ASN", "asn.number", response.getAutonomousSystemNumber());
        }
        if (this.wantAsnOrganization) {
            parsable.addDissection(inputname, "STRING", "asn.organization", response.getAutonomousSystemOrganization());
        }
    }
}

