/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import nl.basjes.parse.httpdlog.ApacheHttpdLogFormatDissector;
import nl.basjes.parse.httpdlog.NginxHttpdLogFormatDissector;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenFormatDissector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpdLogFormatDissector
extends Dissector {
    private static final Logger LOG = LoggerFactory.getLogger(HttpdLogFormatDissector.class);
    public static final String INPUT_TYPE = "HTTPLOGLINE";
    private List<TokenFormatDissector> dissectors = new ArrayList<TokenFormatDissector>(16);
    private TokenFormatDissector activeDissector = null;

    public HttpdLogFormatDissector() {
    }

    public HttpdLogFormatDissector(String multiLineLogFormat) {
        this();
        this.addMultipleLogFormats(multiLineLogFormat);
    }

    public void addMultipleLogFormats(String multiLineLogFormat) {
        for (String logFormat : multiLineLogFormat.split("\\r?\\n")) {
            this.addLogFormat(logFormat);
        }
    }

    public void addLogFormat(List<String> logFormats) {
        for (String logFormat : logFormats) {
            this.addLogFormat(logFormat);
        }
    }

    public void addLogFormat(String logFormat) {
        if (logFormat == null || logFormat.trim().isEmpty()) {
            return;
        }
        switch (this.determineMostLikelyLogFormat(logFormat)) {
            case APACHE: {
                LOG.info("Registering APACHE HTTPD LogFormat[" + this.dissectors.size() + "]= >>" + logFormat + "<<");
                this.dissectors.add(new ApacheHttpdLogFormatDissector(logFormat));
                break;
            }
            case NGINX: {
                LOG.info("Registering NGINX LogFormat[" + this.dissectors.size() + "]= >>" + logFormat + "<<");
                this.dissectors.add(new NginxHttpdLogFormatDissector(logFormat));
                break;
            }
            default: {
                LOG.error("Unable to determine if this is an APACHE or a NGINX LogFormat= >>" + logFormat + "<<");
            }
        }
    }

    private LogFormatType determineMostLikelyLogFormat(String logFormat) {
        return LogFormatType.APACHE;
    }

    public boolean initializeFromSettingsParameter(String multiLineLogFormat) {
        this.addMultipleLogFormats(multiLineLogFormat);
        return true;
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        if (this.dissectors.isEmpty()) {
            throw new DissectionFailure("We need one or more logformats before we can dissect.");
        }
        if (this.activeDissector == null) {
            this.activeDissector = this.dissectors.get(0);
            LOG.info("At start we use LogFormat[0]= >>" + this.activeDissector.getLogFormat() + "<<");
        }
        try {
            this.activeDissector.dissect(parsable, inputname);
            return;
        }
        catch (DissectionFailure df) {
            int index = 0;
            for (TokenFormatDissector dissector : this.dissectors) {
                try {
                    dissector.dissect(parsable, inputname);
                    this.activeDissector = dissector;
                    return;
                }
                catch (DissectionFailure e) {
                    ++index;
                }
            }
            throw df;
        }
    }

    public String getInputType() {
        return INPUT_TYPE;
    }

    public List<String> getPossibleOutput() {
        if (this.dissectors.size() == 0) {
            return null;
        }
        HashSet result = new HashSet(32);
        for (Dissector dissector : this.dissectors) {
            result.addAll(dissector.getPossibleOutput());
        }
        return new ArrayList<String>(result);
    }

    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        if (this.dissectors.size() == 0) {
            return null;
        }
        EnumSet<Casts> result = EnumSet.noneOf(Casts.class);
        for (Dissector dissector : this.dissectors) {
            result.addAll(dissector.prepareForDissect(inputname, outputname));
        }
        return result;
    }

    public void prepareForRun() throws InvalidDissectorException {
        if (this.dissectors.size() == 0) {
            throw new InvalidDissectorException("Cannot run without logformats");
        }
        for (Dissector dissector : this.dissectors) {
            dissector.prepareForRun();
        }
    }

    private List<String> getAllLogFormats() {
        ArrayList<String> result = new ArrayList<String>(this.dissectors.size());
        for (Dissector dissector : this.dissectors) {
            if (!(dissector instanceof TokenFormatDissector)) continue;
            result.add(((TokenFormatDissector)dissector).getLogFormat());
        }
        return result;
    }

    protected void initializeNewInstance(Dissector newInstance) {
        if (this.dissectors.size() == 0) {
            return;
        }
        if (newInstance instanceof HttpdLogFormatDissector) {
            ((HttpdLogFormatDissector)newInstance).addLogFormat(this.getAllLogFormats());
        } else {
            LOG.error("============================== WTF == " + newInstance.getClass().getCanonicalName());
        }
    }

    private static enum LogFormatType {
        APACHE,
        NGINX;

    }
}

