/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.dissectors.http;

import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DissectionFailure;

public class ResponseSetCookieDissector
extends Dissector {
    private static final String INPUT_TYPE = "HTTP.SETCOOKIE";

    public String getInputType() {
        return INPUT_TYPE;
    }

    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("STRING:value");
        result.add("STRING:expires");
        result.add("STRING:path");
        result.add("STRING:domain");
        return result;
    }

    public boolean initializeFromSettingsParameter(String settings) {
        return true;
    }

    protected void initializeNewInstance(Dissector newInstance) {
    }

    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        return Casts.STRING_ONLY;
    }

    public void prepareForRun() {
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        ParsedField field = parsable.getParsableField(INPUT_TYPE, inputname);
        String fieldValue = field.getValue();
        if (fieldValue == null || fieldValue.isEmpty()) {
            return;
        }
        Long nowSeconds = System.currentTimeMillis() / 1000L;
        List<HttpCookie> cookies = HttpCookie.parse(fieldValue);
        for (HttpCookie cookie : cookies) {
            parsable.addDissection(inputname, this.getDissectionType(inputname, "value"), "value", cookie.getValue());
            parsable.addDissection(inputname, this.getDissectionType(inputname, "expires"), "expires", Long.toString(nowSeconds + cookie.getMaxAge()));
            parsable.addDissection(inputname, this.getDissectionType(inputname, "path"), "path", cookie.getPath());
            parsable.addDissection(inputname, this.getDissectionType(inputname, "domain"), "domain", cookie.getDomain());
            parsable.addDissection(inputname, this.getDissectionType(inputname, "comment"), "comment", cookie.getComment());
        }
    }

    public String getDissectionType(String basename, String name) {
        return "STRING";
    }
}

