/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.apachehttpdlog;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.basjes.parse.Utils;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.dissectors.tokenformat.NamedTokenParser;
import nl.basjes.parse.dissectors.tokenformat.TokenFormatDissector;
import nl.basjes.parse.dissectors.tokenformat.TokenParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApacheHttpdLogFormatDissector
extends TokenFormatDissector {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheHttpdLogFormatDissector.class);
    public static final String INPUT_TYPE = "APACHELOGLINE";

    public ApacheHttpdLogFormatDissector(String logFormat) {
        super(logFormat);
        this.setInputType(INPUT_TYPE);
    }

    public ApacheHttpdLogFormatDissector() {
        this.setInputType(INPUT_TYPE);
    }

    private void overrideLogFormat(String originalLogformat, String logformat) {
        LOG.debug("Specified logformat \"" + originalLogformat + "\" was mapped to " + logformat);
        super.setLogFormat(logformat);
    }

    @Override
    public void setLogFormat(String logformat) {
        switch (logformat.toLowerCase(Locale.getDefault())) {
            case "common": {
                this.overrideLogFormat(logformat, "%h %l %u %t \"%r\" %>s %b");
                break;
            }
            case "combined": {
                this.overrideLogFormat(logformat, "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\"");
                break;
            }
            case "combinedio": {
                this.overrideLogFormat(logformat, "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\" %I %O");
                break;
            }
            case "referer": {
                this.overrideLogFormat(logformat, "%{Referer}i -> %U");
                break;
            }
            case "agent": {
                this.overrideLogFormat(logformat, "%{User-agent}i");
                break;
            }
            default: {
                super.setLogFormat(logformat);
            }
        }
    }

    protected String makeHeaderNamesLowercaseInLogFormat(String logformat) {
        StringBuffer sb = new StringBuffer(logformat.length());
        Pattern p = Pattern.compile("\\{([^\\}]*)\\}");
        Matcher m = p.matcher(logformat);
        while (m.find()) {
            m.appendReplacement(sb, '{' + m.group(1).toLowerCase() + '}');
        }
        m.appendTail(sb);
        return sb.toString();
    }

    protected String removeModifiersFromLogformat(String tokenLogFormat) {
        return tokenLogFormat.replaceAll("%!?[0-9]{3}(?:,[0-9]{3})*", "%");
    }

    @Override
    protected String cleanupLogFormat(String tokenLogFormat) {
        return this.makeHeaderNamesLowercaseInLogFormat(this.removeModifiersFromLogformat(tokenLogFormat));
    }

    @Override
    public String decodeExtractedValue(String tokenName, String value) {
        if (value == null || value.equals("")) {
            return value;
        }
        if (value.equals("-")) {
            return null;
        }
        if (value.equals("request.firstline") || value.startsWith("request.header.") || value.startsWith("response.header.")) {
            return Utils.decodeApacheHTTPDLogValue(value);
        }
        return value;
    }

    @Override
    protected List<TokenParser> createAllTokenParsers() {
        ArrayList<TokenParser> parsers = new ArrayList<TokenParser>(60);
        parsers.add(new TokenParser("%%", "FIXED_STRING", "NONE", null, "%"));
        parsers.add(new TokenParser("%a", "connection.client.ip", "IP", Casts.STRING_OR_LONG, "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|:?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}(?::|::)?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}|-"));
        parsers.add(new TokenParser("%{c}a", "connection.client.peerip", "IP", Casts.STRING_OR_LONG, "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|:?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}(?::|::)?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}|-"));
        parsers.add(new TokenParser("%A", "connection.server.ip", "IP", Casts.STRING_OR_LONG, "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|:?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}(?::|::)?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}|-"));
        parsers.add(new TokenParser("%B", "response.body.bytes", "BYTES", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%b", "response.body.bytesclf", "BYTES", Casts.STRING_OR_LONG, "[0-9]*|-"));
        parsers.add(new NamedTokenParser("\\%\\{([a-z0-9\\-_]*)\\}C", "request.cookies.", "HTTP.COOKIE", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("%D", "server.process.time", "MICROSECONDS", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new NamedTokenParser("\\%\\{([a-z0-9\\-_]*)\\}e", "server.environment.", "VARIABLE", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("%f", "server.filename", "FILENAME", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("%h", "connection.client.host", "IP", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("%H", "request.protocol", "PROTOCOL", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new NamedTokenParser("\\%\\{([a-z0-9\\-_]*)\\}i", "request.header.", "HTTP.HEADER", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("%k", "connection.keepalivecount", "NUMBER", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%l", "connection.client.logname", "NUMBER", Casts.STRING_OR_LONG, "[0-9]*|-"));
        parsers.add(new TokenParser("%L", "request.errorlogid", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("%m", "request.method", "HTTP.METHOD", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new NamedTokenParser("\\%\\{([a-z0-9\\-_]*)\\}n", "server.module_note.", "STRING", Casts.STRING_ONLY, ".*"));
        parsers.add(new NamedTokenParser("\\%\\{([a-z0-9\\-]*)\\}o", "response.header.", "HTTP.HEADER", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("%p", "request.server.port.canonical", "PORT", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{canonical}p", "connection.server.port.canonical", "PORT", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{local}p", "connection.server.port", "PORT", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{remote}p", "connection.client.port", "PORT", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%P", "connection.server.child.processid", "NUMBER", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{pid}P", "connection.server.child.processid", "NUMBER", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{tid}P", "connection.server.child.threadid", "NUMBER", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{hextid}P", "connection.server.child.hexthreadid", "NUMBER", Casts.STRING_OR_LONG, "[0-9a-fA-F]*|-"));
        parsers.add(new TokenParser("%q", "request.querystring", "HTTP.QUERYSTRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("%r", "request.firstline", "HTTP.FIRSTLINE", Casts.STRING_ONLY, "[a-zA-Z]+ .* HTTP/[0-9]+\\.[0-9]+"));
        parsers.add(new TokenParser("%R", "request.handler", "STRING", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("%s", "request.status.original", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("%>s", "request.status.last", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("%t", "request.receive.time", "TIME.STAMP", Casts.STRING_ONLY, "\\[[0-3][0-9]/(?:[A-Z][a-z][a-z])/2[0-9][0-9][0-9]:[0-9][0-9]:[0-9][0-9]:[0-9][0-9] [\\+|\\-][0-9][0-9][0-9]0\\]"));
        parsers.add(new TokenParser("%{msec}t", "request.receive.time.begin.msec", "TIME.EPOCH", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{begin:msec}t", "request.receive.time.begin.msec", "TIME.EPOCH", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{end:msec}t", "request.receive.time.end.msec", "TIME.EPOCH", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{usec}t", "request.receive.time.begin.usec", "TIME.EPOCH.USEC", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{begin:usec}t", "request.receive.time.begin.usec", "TIME.EPOCH.USEC", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{end:usec}t", "request.receive.time.end.usec", "TIME.EPOCH.USEC", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{msec_frac}t", "request.receive.time.begin.msec_frac", "TIME.EPOCH", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{begin:msec_frac}t", "request.receive.time.begin.msec_frac", "TIME.EPOCH", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{end:msec_frac}t", "request.receive.time.end.msec_frac", "TIME.EPOCH", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{usec_frac}t", "request.receive.time.begin.usec_frac", "TIME.EPOCH.USEC_FRAC", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{begin:usec_frac}t", "request.receive.time.begin.usec_frac", "TIME.EPOCH.USEC_FRAC", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{end:usec_frac}t", "request.receive.time.end.usec_frac", "TIME.EPOCH.USEC_FRAC", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new NamedTokenParser("\\%\\{([^\\}]*)\\}t", "", "", null, " ])========== %{format}t is not fully supported ==========[( ", -1));
        parsers.add(new TokenParser("%T", "response.server.processing.time", "SECONDS", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%u", "connection.client.user", "STRING", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("%U", "request.urlpath", "URI", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("%v", "connection.server.name.canonical", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("%V", "connection.server.name", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("%X", "response.connection.status", "HTTP.CONNECTSTATUS", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("%I", "request.bytes", "BYTES", Casts.STRING_OR_LONG, "[1-9]|[1-9][0-9]*"));
        parsers.add(new TokenParser("%O", "response.bytes", "BYTES", Casts.STRING_OR_LONG, "[1-9]|[1-9][0-9]*"));
        parsers.add(new TokenParser("%{cookie}i", "request.cookies", "HTTP.COOKIES", Casts.STRING_ONLY, ".*", 1));
        parsers.add(new TokenParser("%{set-cookie}o", "response.cookies", "HTTP.SETCOOKIES", Casts.STRING_ONLY, ".*", 1));
        parsers.add(new TokenParser("%{user-agent}i", "request.user-agent", "HTTP.USERAGENT", Casts.STRING_ONLY, ".*", 1));
        parsers.add(new TokenParser("%{referer}i", "request.referer", "HTTP.URI", Casts.STRING_ONLY, ".*", 1));
        return parsers;
    }
}

