/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.dissectors.http;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeStampDissector
extends Dissector {
    private static final Logger LOG = LoggerFactory.getLogger(TimeStampDissector.class);
    private DateTimeFormatter formatter;
    private DateTimeFormatter asParsedFormatter;
    private String dateTimePattern;
    private static final String INPUT_TYPE = "TIME.STAMP";
    private boolean wantAnyAsParsed = false;
    private boolean wantAnyGMT = false;
    private boolean wantAnyTZIndependent = false;
    private boolean wantDay = false;
    private boolean wantMonthname = false;
    private boolean wantMonth = false;
    private boolean wantWeekOfWeekYear = false;
    private boolean wantWeekYear = false;
    private boolean wantYear = false;
    private boolean wantHour = false;
    private boolean wantMinute = false;
    private boolean wantSecond = false;
    private boolean wantMillisecond = false;
    private boolean wantTimezone = false;
    private boolean wantEpoch = false;
    private boolean wantDayGMT = false;
    private boolean wantMonthnameGMT = false;
    private boolean wantMonthGMT = false;
    private boolean wantWeekOfWeekYearGMT = false;
    private boolean wantWeekYearGMT = false;
    private boolean wantYearGMT = false;
    private boolean wantHourGMT = false;
    private boolean wantMinuteGMT = false;
    private boolean wantSecondGMT = false;
    private boolean wantMillisecondGMT = false;

    public TimeStampDissector() {
        this.setDateTimePattern("[dd/MMM/yyyy:HH:mm:ss ZZ]");
    }

    public TimeStampDissector(String newDateTimePattern) {
        this.setDateTimePattern(newDateTimePattern);
    }

    public boolean initializeFromSettingsParameter(String settings) {
        this.setDateTimePattern(settings);
        return true;
    }

    public void setDateTimePattern(String newDateTimePattern) {
        this.dateTimePattern = newDateTimePattern;
        this.formatter = DateTimeFormat.forPattern((String)this.dateTimePattern).withZone(DateTimeZone.UTC);
        this.asParsedFormatter = this.formatter.withOffsetParsed();
    }

    protected void initializeNewInstance(Dissector newInstance) {
        ((TimeStampDissector)newInstance).setDateTimePattern(this.dateTimePattern);
    }

    public String getInputType() {
        return INPUT_TYPE;
    }

    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("TIME.DAY:day");
        result.add("TIME.MONTHNAME:monthname");
        result.add("TIME.MONTH:month");
        result.add("TIME.WEEK:weekofweekyear");
        result.add("TIME.YEAR:weekyear");
        result.add("TIME.YEAR:year");
        result.add("TIME.HOUR:hour");
        result.add("TIME.MINUTE:minute");
        result.add("TIME.SECOND:second");
        result.add("TIME.MILLISECOND:millisecond");
        result.add("TIME.ZONE:timezone");
        result.add("TIME.EPOCH:epoch");
        result.add("TIME.DAY:day_gmt");
        result.add("TIME.MONTHNAME:monthname_gmt");
        result.add("TIME.MONTH:month_gmt");
        result.add("TIME.WEEK:weekofweekyear_gmt");
        result.add("TIME.YEAR:weekyear_gmt");
        result.add("TIME.YEAR:year_gmt");
        result.add("TIME.HOUR:hour_gmt");
        result.add("TIME.MINUTE:minute_gmt");
        result.add("TIME.SECOND:second_gmt");
        result.add("TIME.MILLISECOND:millisecond_gmt");
        return result;
    }

    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        String name;
        switch (name = outputname.substring(inputname.length() + 1)) {
            case "day": {
                this.wantDay = true;
                return Casts.STRING_OR_LONG;
            }
            case "monthname": {
                this.wantMonthname = true;
                return Casts.STRING_ONLY;
            }
            case "month": {
                this.wantMonth = true;
                return Casts.STRING_OR_LONG;
            }
            case "weekofweekyear": {
                this.wantWeekOfWeekYear = true;
                return Casts.STRING_OR_LONG;
            }
            case "weekyear": {
                this.wantWeekYear = true;
                return Casts.STRING_OR_LONG;
            }
            case "year": {
                this.wantYear = true;
                return Casts.STRING_OR_LONG;
            }
            case "hour": {
                this.wantHour = true;
                return Casts.STRING_OR_LONG;
            }
            case "minute": {
                this.wantMinute = true;
                return Casts.STRING_OR_LONG;
            }
            case "second": {
                this.wantSecond = true;
                return Casts.STRING_OR_LONG;
            }
            case "millisecond": {
                this.wantMillisecond = true;
                return Casts.STRING_OR_LONG;
            }
            case "timezone": {
                this.wantTimezone = true;
                return Casts.STRING_ONLY;
            }
            case "epoch": {
                this.wantEpoch = true;
                return Casts.STRING_OR_LONG;
            }
            case "day_gmt": {
                this.wantDayGMT = true;
                return Casts.STRING_OR_LONG;
            }
            case "monthname_gmt": {
                this.wantMonthnameGMT = true;
                return Casts.STRING_ONLY;
            }
            case "month_gmt": {
                this.wantMonthGMT = true;
                return Casts.STRING_OR_LONG;
            }
            case "weekofweekyear_gmt": {
                this.wantWeekOfWeekYearGMT = true;
                return Casts.STRING_OR_LONG;
            }
            case "weekyear_gmt": {
                this.wantWeekYearGMT = true;
                return Casts.STRING_OR_LONG;
            }
            case "year_gmt": {
                this.wantYearGMT = true;
                return Casts.STRING_OR_LONG;
            }
            case "hour_gmt": {
                this.wantHourGMT = true;
                return Casts.STRING_OR_LONG;
            }
            case "minute_gmt": {
                this.wantMinuteGMT = true;
                return Casts.STRING_OR_LONG;
            }
            case "second_gmt": {
                this.wantSecondGMT = true;
                return Casts.STRING_OR_LONG;
            }
            case "millisecond_gmt": {
                this.wantMillisecondGMT = true;
                return Casts.STRING_OR_LONG;
            }
        }
        return null;
    }

    public void prepareForRun() {
        this.wantAnyAsParsed = this.wantDay || this.wantMonthname || this.wantMonth || this.wantWeekOfWeekYear || this.wantWeekYear || this.wantYear || this.wantHour || this.wantMinute || this.wantSecond || this.wantMillisecond;
        this.wantAnyTZIndependent = this.wantTimezone || this.wantEpoch;
        this.wantAnyGMT = this.wantDayGMT || this.wantMonthnameGMT || this.wantMonthGMT || this.wantWeekOfWeekYearGMT || this.wantWeekYearGMT || this.wantYearGMT || this.wantHourGMT || this.wantMinuteGMT || this.wantSecondGMT || this.wantMillisecondGMT;
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        DateTime dateTime;
        ParsedField field = parsable.getParsableField(INPUT_TYPE, inputname);
        String fieldValue = field.getValue();
        if (fieldValue == null || fieldValue.isEmpty()) {
            return;
        }
        if (this.wantAnyAsParsed || this.wantAnyTZIndependent) {
            dateTime = this.asParsedFormatter.parseDateTime(fieldValue);
            DateTimeZone zone = dateTime.getZone();
            DateTimeFormatter asParsedWithZoneFormatter = this.asParsedFormatter.withZone(zone);
            dateTime = asParsedWithZoneFormatter.parseDateTime(fieldValue);
            if (this.wantDay) {
                parsable.addDissection(inputname, "TIME.DAY", "day", dateTime.dayOfMonth().getAsString());
            }
            if (this.wantMonthname) {
                parsable.addDissection(inputname, "TIME.MONTHNAME", "monthname", dateTime.monthOfYear().getAsText(Locale.getDefault()));
            }
            if (this.wantMonth) {
                parsable.addDissection(inputname, "TIME.MONTH", "month", dateTime.monthOfYear().getAsString());
            }
            if (this.wantWeekOfWeekYear) {
                parsable.addDissection(inputname, "TIME.WEEK", "weekofweekyear", dateTime.weekOfWeekyear().getAsString());
            }
            if (this.wantWeekYear) {
                parsable.addDissection(inputname, "TIME.YEAR", "weekyear", dateTime.weekyear().getAsString());
            }
            if (this.wantYear) {
                parsable.addDissection(inputname, "TIME.YEAR", "year", dateTime.year().getAsString());
            }
            if (this.wantHour) {
                parsable.addDissection(inputname, "TIME.HOUR", "hour", dateTime.hourOfDay().getAsString());
            }
            if (this.wantMinute) {
                parsable.addDissection(inputname, "TIME.MINUTE", "minute", dateTime.minuteOfHour().getAsString());
            }
            if (this.wantSecond) {
                parsable.addDissection(inputname, "TIME.SECOND", "second", dateTime.secondOfMinute().getAsString());
            }
            if (this.wantMillisecond) {
                parsable.addDissection(inputname, "TIME.MILLISECOND", "millisecond", dateTime.millisOfSecond().getAsString());
            }
            if (this.wantTimezone) {
                parsable.addDissection(inputname, "TIME.TIMEZONE", "timezone", dateTime.getZone().getID());
            }
            if (this.wantEpoch) {
                parsable.addDissection(inputname, "TIME.EPOCH", "epoch", Long.toString(dateTime.getMillis()));
            }
        }
        if (this.wantAnyGMT) {
            dateTime = this.formatter.parseDateTime(fieldValue);
            if (this.wantDayGMT) {
                parsable.addDissection(inputname, "TIME.DAY", "day_gmt", dateTime.dayOfMonth().getAsString());
            }
            if (this.wantMonthnameGMT) {
                parsable.addDissection(inputname, "TIME.MONTHNAME", "monthname_gmt", dateTime.monthOfYear().getAsText(Locale.getDefault()));
            }
            if (this.wantMonthGMT) {
                parsable.addDissection(inputname, "TIME.MONTH", "month_gmt", dateTime.monthOfYear().getAsString());
            }
            if (this.wantWeekOfWeekYearGMT) {
                parsable.addDissection(inputname, "TIME.WEEK", "weekofweekyear_gmt", dateTime.weekOfWeekyear().getAsString());
            }
            if (this.wantWeekYearGMT) {
                parsable.addDissection(inputname, "TIME.YEAR", "weekyear_gmt", dateTime.weekyear().getAsString());
            }
            if (this.wantYearGMT) {
                parsable.addDissection(inputname, "TIME.YEAR", "year_gmt", dateTime.year().getAsString());
            }
            if (this.wantHourGMT) {
                parsable.addDissection(inputname, "TIME.HOUR", "hour_gmt", dateTime.hourOfDay().getAsString());
            }
            if (this.wantMinuteGMT) {
                parsable.addDissection(inputname, "TIME.MINUTE", "minute_gmt", dateTime.minuteOfHour().getAsString());
            }
            if (this.wantSecondGMT) {
                parsable.addDissection(inputname, "TIME.SECOND", "second_gmt", dateTime.secondOfMinute().getAsString());
            }
            if (this.wantMillisecondGMT) {
                parsable.addDissection(inputname, "TIME.MILLISECOND", "millisecond_gmt", dateTime.millisOfSecond().getAsString());
            }
        }
    }
}

