/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.hadoop.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.basjes.hadoop.input.ParsedRecord;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import nl.basjes.parse.core.exceptions.MissingDissectorsException;
import nl.basjes.parse.httpdlog.HttpdLoglineParser;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpdLogfileRecordReader
extends RecordReader<LongWritable, ParsedRecord> {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheHttpdLogfileRecordReader.class);
    private static final String HTTPD_LOGFILE_INPUT_FORMAT = "HTTPD Access Logfile InputFormat";
    public static final String FIELDS = "fields";
    private final LineRecordReader lineReader = new LineRecordReader();
    private Parser<ParsedRecord> parser;
    private List<String> fieldList = null;
    private final ParsedRecord currentValue = new ParsedRecord();
    private String logformat = null;
    private final Set<String> requestedFields = new HashSet<String>();
    private Map<String, Set<String>> typeRemappings = new HashMap<String, Set<String>>(16);
    private List<Dissector> additionalDissectors;
    private boolean outputAllPossibleFields = false;
    private String allPossiblePathsFieldName;
    private List<String> allPossiblePaths = null;
    private Counter counterLinesRead;
    private Counter counterGoodLines;
    private Counter counterBadLines;
    private Map<String, EnumSet<Casts>> allCasts;
    private int errorLinesLogged = 0;
    private static final int MAX_ERROR_LINES_LOGGED = 10;

    public ApacheHttpdLogfileRecordReader() {
    }

    public ApacheHttpdLogfileRecordReader(String logformat, Set<String> requestedFields, Map<String, Set<String>> typeRemappings, List<Dissector> additionalDissectors) {
        this.setLogFormat(logformat);
        this.typeRemappings = typeRemappings;
        this.additionalDissectors = additionalDissectors;
        this.addRequestedFields(requestedFields);
    }

    private void addRequestedFields(Set<String> newRequestedFields) {
        this.requestedFields.addAll(newRequestedFields);
        this.fieldList = new ArrayList<String>(this.requestedFields);
        this.setupFields();
    }

    private void setLogFormat(String newLogformat) {
        if (newLogformat == null) {
            return;
        }
        this.logformat = newLogformat;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
        this.lineReader.initialize(split, context);
        Configuration conf = context.getConfiguration();
        this.counterLinesRead = context.getCounter(HTTPD_LOGFILE_INPUT_FORMAT, "1:Lines read");
        this.counterGoodLines = context.getCounter(HTTPD_LOGFILE_INPUT_FORMAT, "2:Good lines");
        this.counterBadLines = context.getCounter(HTTPD_LOGFILE_INPUT_FORMAT, "3:Bad lines");
        if (this.logformat == null || this.requestedFields.isEmpty()) {
            if (this.logformat == null) {
                this.logformat = conf.get("nl.basjes.parse.apachehttpdlogline.format", "common");
            }
            if (this.requestedFields.isEmpty()) {
                String fields = conf.get("nl.basjes.parse.apachehttpdlogline.fields", null);
                if (fields != null) {
                    this.fieldList = Arrays.asList(fields.split(","));
                }
            } else {
                this.fieldList = new ArrayList<String>(this.requestedFields);
            }
        }
        if (this.fieldList != null) {
            if (this.logformat != null && this.parser == null) {
                this.parser = this.createParser();
            }
            for (String field : this.fieldList) {
                this.currentValue.declareRequestedFieldname(field);
            }
        }
        this.setupFields();
    }

    protected Parser<ParsedRecord> instantiateParser(String logFormat) {
        HttpdLoglineParser newParser = new HttpdLoglineParser(ParsedRecord.class, logFormat);
        newParser.setTypeRemappings(this.typeRemappings);
        newParser.addDissectors(this.additionalDissectors);
        return newParser;
    }

    private void setupFields() {
        if (this.fieldList == null || this.fieldList.isEmpty()) {
            return;
        }
        try {
            String firstField = this.fieldList.get(0);
            if (this.fieldList.size() == 1 && firstField.toLowerCase().trim().equals(FIELDS)) {
                this.outputAllPossibleFields = true;
                this.allPossiblePaths = this.getParser().getPossiblePaths();
                this.allPossiblePathsFieldName = firstField;
                Parser<ParsedRecord> newParser = this.instantiateParser(this.logformat);
                newParser.addParseTarget(ParsedRecord.class.getMethod("set", String.class, String.class), this.allPossiblePaths);
                newParser.addTypeRemappings(this.typeRemappings);
                this.allCasts = newParser.getAllCasts();
            }
        }
        catch (IOException | NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public EnumSet<Casts> getCasts(String name) throws IOException {
        if (this.outputAllPossibleFields) {
            return this.allCasts.get(name);
        }
        return this.getParser().getCasts(name);
    }

    public Parser<ParsedRecord> getParser() throws IOException {
        if (this.parser == null) {
            this.parser = this.createParser();
        }
        return this.parser;
    }

    private Parser<ParsedRecord> createParser() throws IOException {
        Parser<ParsedRecord> newParser;
        if (this.fieldList == null || this.logformat == null) {
            return null;
        }
        try {
            newParser = this.instantiateParser(this.logformat);
            for (String field : this.fieldList) {
                if (field.endsWith(".*")) {
                    newParser.addParseTarget(ParsedRecord.class.getMethod("setMultiValueString", String.class, String.class), field);
                    continue;
                }
                newParser.addParseTarget(ParsedRecord.class.getMethod("set", String.class, String.class), field);
                newParser.addParseTarget(ParsedRecord.class.getMethod("set", String.class, Long.class), field);
                newParser.addParseTarget(ParsedRecord.class.getMethod("set", String.class, Double.class), field);
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IOException(e.toString());
        }
        return newParser;
    }

    public boolean nextKeyValue() throws IOException {
        if (this.outputAllPossibleFields) {
            if (this.allPossiblePaths.isEmpty()) {
                return false;
            }
            this.currentValue.clear();
            String value = this.allPossiblePaths.get(0);
            this.allPossiblePaths.remove(0);
            this.currentValue.set(this.allPossiblePathsFieldName, value);
            return true;
        }
        boolean haveValue = false;
        while (!haveValue) {
            if (!this.lineReader.nextKeyValue()) {
                return false;
            }
            this.counterLinesRead.increment(1L);
            this.currentValue.clear();
            String inputLine = this.lineReader.getCurrentValue().toString();
            try {
                this.getParser().parse((Object)this.currentValue, this.lineReader.getCurrentValue().toString());
                this.counterGoodLines.increment(1L);
                haveValue = true;
            }
            catch (DissectionFailure e) {
                this.counterBadLines.increment(1L);
                if (this.errorLinesLogged >= 10) continue;
                LOG.error("Parse error >>>{}<<< in line: >>>{}<<<", (Object)e.getMessage(), (Object)inputLine);
                ++this.errorLinesLogged;
                if (this.errorLinesLogged != 10) continue;
                LOG.error(">>>>>>>>>>> We now stop logging parse errors! <<<<<<<<<<<");
            }
            catch (InvalidDissectorException e) {
                LOG.error("InvalidDissectorException >>>{}<<<", (Object)e.getMessage());
                return false;
            }
            catch (MissingDissectorsException e) {
                LOG.error("MissingDissectorsException >>>{}<<<", (Object)e.getMessage());
                return false;
            }
        }
        return true;
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.lineReader.getCurrentKey();
    }

    public ParsedRecord getCurrentValue() {
        return this.currentValue;
    }

    public float getProgress() throws IOException {
        return this.lineReader.getProgress();
    }

    public void close() throws IOException {
        this.lineReader.close();
    }
}

