/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.hadoop.input;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.basjes.hadoop.input.ParsedRecord;
import nl.basjes.parse.apachehttpdlog.ApacheHttpdLoglineParser;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.exceptions.DisectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDisectorException;
import nl.basjes.parse.core.exceptions.MissingDisectorsException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpdLogfileRecordReader
extends RecordReader<LongWritable, MapWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheHttpdLogfileRecordReader.class);
    private static final String APACHE_HTTPD_LOGFILE_INPUT_FORMAT = "Apache HTTPD Logfile InputFormat";
    public static final String FIELDS = "fields";
    private final LineRecordReader lineReader = new LineRecordReader();
    private Parser<ParsedRecord> parser;
    private List<String> fieldList = null;
    private final ParsedRecord currentValue = new ParsedRecord();
    private String logformat = null;
    private final Set<String> requestedFields = new HashSet<String>();
    private boolean outputAllPossibleFields = false;
    private String allPossiblePathsFieldName;
    private List<String> allPossiblePaths = null;
    private Counter counterLinesRead;
    private Counter counterGoodLines;
    private Counter counterBadLines;
    private Map<String, EnumSet<Casts>> allCasts;
    private int errorLinesLogged = 0;
    private static final int MAX_ERROR_LINES_LOGGED = 10;

    public ApacheHttpdLogfileRecordReader() {
    }

    public ApacheHttpdLogfileRecordReader(String newLogformat, Set<String> newRequestedFields) {
        this.setLogFormat(newLogformat);
        this.addRequestedFields(newRequestedFields);
    }

    private void addRequestedFields(Set<String> newRequestedFields) {
        this.requestedFields.addAll(newRequestedFields);
        this.fieldList = new ArrayList<String>(this.requestedFields);
        this.setupFields();
    }

    private void setLogFormat(String newLogformat) {
        if (newLogformat == null) {
            return;
        }
        this.logformat = newLogformat;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
        this.lineReader.initialize(split, context);
        Configuration conf = context.getConfiguration();
        this.counterLinesRead = context.getCounter(APACHE_HTTPD_LOGFILE_INPUT_FORMAT, "1:Lines read");
        this.counterGoodLines = context.getCounter(APACHE_HTTPD_LOGFILE_INPUT_FORMAT, "2:Good lines");
        this.counterBadLines = context.getCounter(APACHE_HTTPD_LOGFILE_INPUT_FORMAT, "3:Bad lines");
        if (this.logformat == null || this.requestedFields.isEmpty()) {
            if (this.logformat == null) {
                this.logformat = conf.get("nl.basjes.parse.apachehttpdlogline.format", "common");
            }
            if (this.requestedFields.isEmpty()) {
                String fields = conf.get("nl.basjes.parse.apachehttpdlogline.fields", null);
                if (fields != null) {
                    this.fieldList = Arrays.asList(fields.split(","));
                }
            } else {
                this.fieldList = new ArrayList<String>(this.requestedFields);
            }
        }
        if (this.logformat != null && this.fieldList != null && this.parser == null) {
            this.parser = this.createParser();
        }
        this.setupFields();
    }

    protected Parser<ParsedRecord> instantiateParser(String logFormat) throws ParseException {
        return new ApacheHttpdLoglineParser(ParsedRecord.class, this.logformat);
    }

    private void setupFields() {
        try {
            String firstField = this.fieldList.get(0);
            if (this.fieldList.size() == 1 && firstField.toLowerCase().trim().equals(FIELDS)) {
                this.outputAllPossibleFields = true;
                this.allPossiblePaths = this.getParser().getPossiblePaths();
                this.allPossiblePathsFieldName = firstField;
                Parser<ParsedRecord> newParser = this.instantiateParser(this.logformat);
                newParser.addParseTarget(ParsedRecord.class.getMethod("set", String.class, String.class), this.allPossiblePaths);
                this.allCasts = newParser.getAllCasts();
            }
        }
        catch (IOException | NoSuchMethodException | ParseException | InvalidDisectorException | MissingDisectorsException e) {
            e.printStackTrace();
        }
    }

    public EnumSet<Casts> getCasts(String name) throws IOException {
        if (this.outputAllPossibleFields) {
            return this.allCasts.get(name);
        }
        return this.getParser().getCasts(name);
    }

    public Parser<ParsedRecord> getParser() throws IOException {
        if (this.parser == null) {
            this.parser = this.createParser();
        }
        return this.parser;
    }

    private Parser<ParsedRecord> createParser() throws IOException {
        Parser<ParsedRecord> newParser;
        if (this.fieldList == null || this.logformat == null) {
            return null;
        }
        try {
            newParser = this.instantiateParser(this.logformat);
            newParser.addParseTarget(ParsedRecord.class.getMethod("set", String.class, String.class), this.fieldList);
            newParser.addParseTarget(ParsedRecord.class.getMethod("set", String.class, Long.class), this.fieldList);
            newParser.addParseTarget(ParsedRecord.class.getMethod("set", String.class, Double.class), this.fieldList);
        }
        catch (NoSuchMethodException | SecurityException | ParseException e) {
            throw new IOException(e.toString());
        }
        return newParser;
    }

    public boolean nextKeyValue() throws IOException {
        if (this.outputAllPossibleFields) {
            if (this.allPossiblePaths.isEmpty()) {
                return false;
            }
            this.currentValue.clear();
            String value = this.allPossiblePaths.get(0);
            this.allPossiblePaths.remove(0);
            this.currentValue.set(this.allPossiblePathsFieldName, value);
            return true;
        }
        boolean haveValue = false;
        while (!haveValue) {
            if (!this.lineReader.nextKeyValue()) {
                return false;
            }
            this.counterLinesRead.increment(1L);
            this.currentValue.clear();
            String inputLine = this.lineReader.getCurrentValue().toString();
            try {
                this.getParser().parse((Object)this.currentValue, this.lineReader.getCurrentValue().toString());
                this.counterGoodLines.increment(1L);
                haveValue = true;
            }
            catch (DisectionFailure e) {
                this.counterBadLines.increment(1L);
                if (this.errorLinesLogged >= 10) continue;
                LOG.error("Parse error >>>{}<<< in line: >>>{}<<<", (Object)e.getMessage(), (Object)inputLine);
                ++this.errorLinesLogged;
                if (this.errorLinesLogged != 10) continue;
                LOG.error(">>>>>>>>>>> We now stop logging parse errors! <<<<<<<<<<<");
            }
            catch (InvalidDisectorException e) {
                LOG.error("InvalidDisectorException >>>{}<<<", (Object)e.getMessage());
                return false;
            }
            catch (MissingDisectorsException e) {
                LOG.error("MissingDisectorsException >>>{}<<<", (Object)e.getMessage());
                return false;
            }
        }
        return true;
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.lineReader.getCurrentKey();
    }

    public MapWritable getCurrentValue() {
        return this.currentValue;
    }

    public float getProgress() throws IOException {
        return this.lineReader.getProgress();
    }

    public void close() throws IOException {
        this.lineReader.close();
    }
}

