/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.gitignore;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import nl.basjes.gitignore.GitIgnore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitIgnoreFileSet
implements FileFilter {
    private static final Logger LOG = LoggerFactory.getLogger(GitIgnoreFileSet.class);
    private final TreeMap<String, GitIgnore> gitIgnores = new TreeMap();
    private final File projectBaseDir;

    public GitIgnoreFileSet(File projectBaseDir) {
        this(projectBaseDir, true);
    }

    public GitIgnoreFileSet(File projectBaseDir, boolean autoload) {
        this.projectBaseDir = projectBaseDir;
        if (autoload) {
            this.addAllGitIgnoreFiles();
        }
    }

    public void setVerbose(boolean verbose) {
        this.gitIgnores.values().forEach(gitIgnore -> gitIgnore.setVerbose(verbose));
    }

    public void add(GitIgnore gitIgnore) {
        this.gitIgnores.put(gitIgnore.getProjectRelativeBaseDir(), gitIgnore);
    }

    public void addGitIgnoreFile(File gitIgnoreFile) {
        try {
            this.add(new GitIgnore(this.getProjectRelative(gitIgnoreFile.getParent()), gitIgnoreFile));
        }
        catch (IOException e) {
            LOG.error("Cannot read {} due to {}. Will skip this file.", (Object)gitIgnoreFile, (Object)e.getMessage());
        }
    }

    public void addAllGitIgnoreFiles() {
        try (Stream<Path> projectFiles = Files.find(this.projectBaseDir.toPath(), 128, (filePath, fileAttr) -> fileAttr.isRegularFile(), new FileVisitOption[0]);){
            projectFiles.filter(filePath -> filePath.getFileName().toString().equals(".gitignore")).forEach(gitIgnoreFile -> this.addGitIgnoreFile(gitIgnoreFile.toFile()));
        }
        catch (IOException e) {
            LOG.error("Unable to find .gitignore files in {} due to {}", (Object)this.projectBaseDir, (Object)e.toString());
        }
    }

    public boolean isEmpty() {
        return this.gitIgnores.isEmpty();
    }

    public Boolean isIgnoredFile(String filename) {
        Boolean result = null;
        String projectBaseFileName = this.getProjectRelative(filename);
        for (GitIgnore gitIgnore : this.gitIgnores.values()) {
            Boolean isIgnoredFile = gitIgnore.isIgnoredFile(projectBaseFileName);
            if (isIgnoredFile == null) continue;
            result = isIgnoredFile;
        }
        return result;
    }

    public boolean ignoreFile(String filename) {
        return Boolean.TRUE.equals(this.isIgnoredFile(filename));
    }

    public boolean keepFile(String filename) {
        return !this.ignoreFile(filename);
    }

    private String getProjectRelative(String fileName) {
        return GitIgnore.standardizeFilename(fileName).replaceAll("^\\Q" + GitIgnore.standardizeFilename(this.projectBaseDir.getPath()) + "\\E", "/").replaceAll("^\\Q" + GitIgnore.standardizeFilename(this.projectBaseDir.getAbsolutePath()) + "\\E", "/").replace("//", "/");
    }

    @Override
    public boolean accept(File pathname) {
        return this.keepFile(pathname.getName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GitIgnoreFileSet\n");
        for (Map.Entry<String, GitIgnore> gitIgnoreEntry : this.gitIgnores.entrySet()) {
            sb.append("# Base directory: ").append(gitIgnoreEntry.getKey()).append("\n").append(gitIgnoreEntry.getValue()).append("=========================\n");
        }
        return sb.toString();
    }
}

