/*
 * Decompiled with CFR 0.152.
 */
package ng.shoppi.androidfrontend.onboarding;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.ArrayList;
import ng.shoppi.androidfrontend.R;
import ng.shoppi.androidfrontend.listeners.OnboardingListener;
import ng.shoppi.androidfrontend.onboarding.OnboardingViews;

class OnboardingActivity
extends AppCompatActivity {
    private SectionsPagerAdapter mSectionsPagerAdapter;
    private Context context;
    private LinearLayout layoutDots;
    private ViewPager mViewPager;
    private Button buttonSkip;
    private Button buttonNext;
    ArrayList<Fragment> layouts = new ArrayList();
    private TextView[] dots;
    private OnboardingListener onboardingListener;
    private static final int DEFAULT_FRAGMENT_COUNT = 3;

    OnboardingActivity() {
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.setContentView(R.layout.lib_shopping_onborading_skeleton_1);
        this.layoutDots = (LinearLayout)this.findViewById(R.id.layoutDots);
        this.mViewPager = (ViewPager)this.findViewById(R.id.container);
        this.buttonSkip = (Button)this.findViewById(R.id.btn_skip);
        this.buttonNext = (Button)this.findViewById(R.id.btn_next);
        this.context = OnboardingViews.mActivity;
        this.onboardingListener = (OnboardingListener)this.context;
        this.setStatusBar();
        Intent intent = this.getIntent();
        if (intent != null && intent.hasExtra("fragment")) {
            int[] layoutIds = intent.getIntArrayExtra("fragment");
            for (int i = 0; i < layoutIds.length; ++i) {
                this.layouts.add(PlaceholderFragment.newInstance(layoutIds[i]));
            }
        } else if (intent != null && intent.hasExtra("default_fragment")) {
            for (int i = 0; i < 3; ++i) {
                this.layouts.add(PlaceholderFragment.newInstance(R.layout.lib_shopping_onboarding_fragment_1));
            }
        }
        this.mSectionsPagerAdapter = new SectionsPagerAdapter(this.getSupportFragmentManager());
        this.mViewPager.setAdapter((PagerAdapter)this.mSectionsPagerAdapter);
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                OnboardingActivity.this.addBottomDots(position);
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.addBottomDots(0);
        this.buttonNext.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                int current = OnboardingActivity.this.getItem(1);
                if (current < OnboardingActivity.this.layouts.size()) {
                    OnboardingActivity.this.mViewPager.setCurrentItem(current);
                } else {
                    OnboardingActivity.this.onboardingListener.onReady();
                }
            }
        });
        this.buttonSkip.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                OnboardingActivity.this.onboardingListener.onSkipClick();
            }
        });
    }

    private int getItem(int i) {
        return this.mViewPager.getCurrentItem() + i;
    }

    private void addBottomDots(int currentPage) {
        this.dots = new TextView[this.layouts.size()];
        int[] colorsActive = this.getResources().getIntArray(R.array.array_dot_active);
        int[] colorsInactive = this.getResources().getIntArray(R.array.array_dot_inactive);
        this.layoutDots.removeAllViews();
        for (int i = 0; i < this.dots.length; ++i) {
            this.dots[i] = new TextView((Context)this);
            this.dots[i].setText((CharSequence)Html.fromHtml((String)"&#8226;"));
            this.dots[i].setTextSize(35.0f);
            this.dots[i].setTextColor(colorsInactive[currentPage]);
            this.layoutDots.addView((View)this.dots[i]);
        }
        if (this.dots.length > 0) {
            this.dots[currentPage].setTextColor(colorsActive[currentPage]);
        }
    }

    private void setStatusBar() {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.clearFlags(0x4000000);
            window.setStatusBarColor(this.context.getResources().getColor(R.color.lib_shopping_colorPrimaryDark));
        }
    }

    public static class PlaceholderFragment
    extends Fragment {
        private static final String LAYOUT_ID = "layout_id";

        public static PlaceholderFragment newInstance(int layoutId) {
            PlaceholderFragment fragment = new PlaceholderFragment();
            Bundle args = new Bundle();
            args.putInt(LAYOUT_ID, layoutId);
            fragment.setArguments(args);
            return fragment;
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            int layoutId = this.getArguments().getInt(LAYOUT_ID);
            return inflater.inflate(layoutId, container, false);
        }
    }

    private class SectionsPagerAdapter
    extends FragmentPagerAdapter {
        SectionsPagerAdapter(FragmentManager fm) {
            super(fm);
        }

        public Fragment getItem(int position) {
            return OnboardingActivity.this.layouts.get(position);
        }

        public int getCount() {
            return OnboardingActivity.this.layouts.size();
        }

        public CharSequence getPageTitle(int position) {
            return null;
        }
    }
}

