/*
 * Decompiled with CFR 0.152.
 */
package ng.shoppi.androidfrontend.genericformhandler;

import android.content.Context;
import android.view.View;
import android.widget.EditText;
import android.widget.ProgressBar;
import ng.shoppi.androidfrontend.listeners.RegistrationOnClickListener;
import ng.shoppi.androidfrontend.models.User;
import ng.shoppi.androidfrontend.util.Utility;

public class RegistrationHandler {
    private EditText editTextFirstname;
    private EditText editTextLastname;
    private EditText editTextEmail;
    private EditText editTextPassword;
    private EditText editTextConfirmPassword;
    private EditText editTextPhone;
    private View signIn;
    private View register;
    private boolean emailValidation;
    private ProgressBar progressBar;
    private RegistrationOnClickListener registrationOnClickListener;

    public RegistrationHandler(EditText firstName, EditText lastName, EditText username, EditText password, EditText editTextConfirmPassword, EditText editTextPhone, boolean emailValidation) {
        this.editTextFirstname = firstName;
        this.editTextLastname = lastName;
        this.editTextEmail = username;
        this.editTextPassword = password;
        this.editTextConfirmPassword = editTextConfirmPassword;
        this.editTextPhone = editTextPhone;
        this.emailValidation = emailValidation;
        this.setUp();
    }

    public RegistrationHandler(EditText firstName, EditText lastName, EditText username, EditText password, EditText editTextConfirmPassword, EditText editTextPhone, View register, View signIn, ProgressBar progressBar, boolean emailValidation) {
        this.editTextFirstname = firstName;
        this.editTextLastname = lastName;
        this.editTextEmail = username;
        this.editTextPassword = password;
        this.editTextConfirmPassword = editTextConfirmPassword;
        this.editTextPhone = editTextPhone;
        this.signIn = signIn;
        this.register = register;
        this.progressBar = progressBar;
        this.emailValidation = emailValidation;
        this.setUp();
    }

    private void setUp() {
        Context context = this.editTextEmail.getContext();
        this.registrationOnClickListener = (RegistrationOnClickListener)context;
        if (this.signIn != null) {
            this.signIn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    RegistrationHandler.this.registrationOnClickListener.onSignInClick();
                }
            });
        }
        if (this.register != null) {
            this.register.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    RegistrationHandler.this.registrationOnClickListener.onRegisterClick();
                }
            });
        }
    }

    public boolean validateInput() {
        return Utility.validateInput(this.editTextFirstname, this.editTextLastname, this.editTextEmail, this.editTextPassword, this.editTextConfirmPassword, this.editTextPhone, this.emailValidation);
    }

    public void showProgressBar(boolean show) {
        if (this.progressBar != null) {
            Utility.showProgressBar(show, this.progressBar);
        }
    }

    public User getUser() {
        return new User(this.editTextFirstname.getText().toString(), this.editTextLastname.getText().toString(), this.editTextEmail.getText().toString(), this.editTextPassword.getText().toString(), this.editTextPhone.getText().toString());
    }
}

