/*
 * Decompiled with CFR 0.152.
 */
package ng.shoppi.androidfrontend.forms;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import de.hdodenhof.circleimageview.CircleImageView;
import ng.shoppi.androidfrontend.R;
import ng.shoppi.androidfrontend.listeners.LoginOnClickListener;
import ng.shoppi.androidfrontend.models.User;
import ng.shoppi.androidfrontend.util.Utility;

public class LoginFormB
extends RelativeLayout {
    private Button signInButton;
    private LinearLayout linearLayoutLoginForm;
    private ProgressBar progressBarSignIn;
    private CircleImageView logo;
    private EditText editTextEmail;
    private EditText editTextPassword;
    private TextView signUpTextView;
    private LoginOnClickListener loginOnClickListener;
    private TextView forgotPasswordTextView;
    private boolean validateEmail;

    public LoginFormB(Context context) {
        super(context);
        this.initView(null);
    }

    public LoginFormB(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(attrs);
    }

    public LoginFormB(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(attrs);
    }

    public LoginFormB(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(attrs);
    }

    private void initView(@Nullable AttributeSet attributeSet) {
        View view = LoginFormB.inflate((Context)this.getContext(), (int)R.layout.lib_shopping_login_1, null);
        if (attributeSet == null) {
            this.addView(view);
            return;
        }
        this.logo = (CircleImageView)view.findViewById(R.id.circle_image_olx);
        this.editTextEmail = (EditText)view.findViewById(R.id.editTextEmail_olx);
        this.editTextPassword = (EditText)view.findViewById(R.id.editTextPassword_olx);
        this.forgotPasswordTextView = (TextView)view.findViewById(R.id.textViewForgotPassword_olx);
        this.signInButton = (Button)view.findViewById(R.id.buttonSignIn_olx);
        this.signUpTextView = (TextView)view.findViewById(R.id.textViewRegister_olx);
        this.linearLayoutLoginForm = (LinearLayout)view.findViewById(R.id.linearLayoutLoginForm_olx);
        this.progressBarSignIn = (ProgressBar)view.findViewById(R.id.progressBarSignIn_olx);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.LoginFormB);
        Drawable logoDrawable = typedArray.getDrawable(R.styleable.LoginFormB_logo_b);
        String userIdLabel = typedArray.getString(R.styleable.LoginFormB_user_id_label_b);
        String signInLabel = typedArray.getString(R.styleable.LoginFormB_sign_in_label_b);
        String signUpLabel = typedArray.getString(R.styleable.LoginFormB_sign_up_label_b);
        this.validateEmail = typedArray.getBoolean(R.styleable.LoginFormB_login_validate_email_b, true);
        if (userIdLabel != null && !userIdLabel.equals("")) {
            this.editTextEmail.setHint((CharSequence)userIdLabel);
        } else {
            this.editTextEmail.setHint((CharSequence)"Email");
        }
        if (signInLabel != null && !signInLabel.equals("")) {
            this.signInButton.setText((CharSequence)signInLabel);
        }
        if (signUpLabel != null && !signUpLabel.equals("")) {
            this.signUpTextView.setText((CharSequence)signUpLabel);
        }
        if (logoDrawable != null) {
            this.logo.setImageDrawable(logoDrawable);
        }
        this.addView(view);
        typedArray.recycle();
    }

    public void init(Context context) {
        this.loginOnClickListener = (LoginOnClickListener)context;
        this.signInButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LoginFormB.this.loginOnClickListener.onSignInClick();
            }
        });
        this.signUpTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LoginFormB.this.loginOnClickListener.onSignUpClick();
            }
        });
        this.forgotPasswordTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LoginFormB.this.loginOnClickListener.onForgetPasswordClick();
            }
        });
    }

    public User getUser() {
        return new User(this.editTextEmail.getText().toString(), this.editTextPassword.getText().toString());
    }

    public boolean validateInput() {
        return Utility.validateInput(this.editTextEmail, this.editTextPassword, this.validateEmail);
    }

    public void showProgressBar(final boolean show) {
        int shortAnimTime = this.getResources().getInteger(0x10E0000);
        this.linearLayoutLoginForm.setVisibility(show ? 8 : 0);
        this.linearLayoutLoginForm.animate().setDuration((long)shortAnimTime).alpha(show ? 0.0f : 1.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                LoginFormB.this.linearLayoutLoginForm.setVisibility(show ? 8 : 0);
            }
        });
        this.progressBarSignIn.setVisibility(show ? 0 : 8);
        this.progressBarSignIn.animate().setDuration((long)shortAnimTime).alpha(show ? 1.0f : 0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                LoginFormB.this.progressBarSignIn.setVisibility(show ? 0 : 8);
            }
        });
    }
}

