/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.utils;

import android.content.SharedPreferences;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import network.path.mobilenode.library.utils.PrefsDelegatesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0003B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ$\u0010\r\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u00022\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011J,\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00022\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\b\u0010\u0014\u001a\u0004\u0018\u00018\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnetwork/path/mobilenode/library/utils/SharedPreferencesOptionalDelegate;", "T", "", "Lkotlin/properties/ReadWriteProperty;", "prefs", "Landroid/content/SharedPreferences;", "name", "", "clazz", "Ljava/lang/Class;", "ttl", "", "(Landroid/content/SharedPreferences;Ljava/lang/String;Ljava/lang/Class;J)V", "getValue", "thisRef", "property", "Lkotlin/reflect/KProperty;", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;)Ljava/lang/Object;", "setValue", "", "value", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;Ljava/lang/Object;)V", "library_release"})
public final class SharedPreferencesOptionalDelegate<T>
implements ReadWriteProperty<Object, T> {
    private final SharedPreferences prefs;
    private final String name;
    private final Class<T> clazz;
    private final long ttl;

    @Nullable
    public T getValue(@NotNull Object thisRef, @NotNull KProperty<?> property) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)thisRef, (String)"thisRef");
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        if (!this.prefs.contains(this.name)) {
            Timber.v((String)("Shared preference [" + this.name + "] is missing."), (Object[])new Object[0]);
            object = null;
        } else {
            long saveTime = this.prefs.getLong(this.name + "_TIME", -1L);
            long curTime = System.currentTimeMillis();
            if (this.ttl != -1L && (saveTime < 0L || curTime - saveTime > this.ttl)) {
                Timber.v((String)("Shared preference [" + this.name + "] is too old (" + curTime + ", " + saveTime + ", " + this.ttl + ')'), (Object[])new Object[0]);
                object = null;
            } else {
                Object object2;
                Class<T> clazz = this.clazz;
                if (Intrinsics.areEqual(clazz, Boolean.TYPE)) {
                    object2 = this.prefs.getBoolean(this.name, false);
                } else if (Intrinsics.areEqual(clazz, Integer.TYPE)) {
                    object2 = this.prefs.getInt(this.name, 0);
                } else if (Intrinsics.areEqual(clazz, Long.TYPE)) {
                    object2 = this.prefs.getLong(this.name, 0L);
                } else if (Intrinsics.areEqual(clazz, Float.TYPE)) {
                    object2 = Float.valueOf(this.prefs.getFloat(this.name, 0.0f));
                } else if (Intrinsics.areEqual(clazz, String.class)) {
                    String string = this.prefs.getString(this.name, "");
                    if (string == null) {
                        throw new TypeCastException("null cannot be cast to non-null type T");
                    }
                    object2 = string;
                } else {
                    throw (Throwable)new RuntimeException("Class " + this.clazz + " is not supported");
                }
                Object value = object2;
                Timber.v((String)("Found shared preference [" + this.name + "] = [" + value + ']'), (Object[])new Object[0]);
                object = value;
            }
        }
        return (T)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(@NotNull Object thisRef, @NotNull KProperty<?> property, @Nullable T value) {
        Intrinsics.checkParameterIsNotNull((Object)thisRef, (String)"thisRef");
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        Timber.v((String)("Saving new shared preference [" + this.name + "] = [" + value + ']'), (Object[])new Object[0]);
        SharedPreferences.Editor editor = this.prefs.edit();
        T t = value;
        if (t == null) {
            editor.remove(this.name);
        } else if (t instanceof Boolean) {
            editor.putBoolean(this.name, ((Boolean)value).booleanValue());
        } else if (t instanceof Integer) {
            editor.putInt(this.name, ((Number)value).intValue());
        } else if (t instanceof Long) {
            editor.putLong(this.name, ((Number)value).longValue());
        } else if (t instanceof Float) {
            editor.putFloat(this.name, ((Number)value).floatValue());
        } else if (t instanceof String) {
            editor.putString(this.name, (String)value);
        } else {
            if (!(t instanceof Set)) throw (Throwable)new RuntimeException("Bundle value " + value + " has wrong type");
            if (!PrefsDelegatesKt.isSetOf((Set)value)) throw (Throwable)new RuntimeException("Bundle value " + value + " has wrong type");
            T t2 = value;
            if (t2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Set<kotlin.String>");
            }
            editor.putStringSet(this.name, (Set)t2);
        }
        if (this.ttl != -1L) {
            editor.putLong(this.name + "_TIME", System.currentTimeMillis());
        }
        editor.apply();
    }

    public SharedPreferencesOptionalDelegate(@NotNull SharedPreferences prefs, @NotNull String name, @NotNull Class<T> clazz, long ttl) {
        Intrinsics.checkParameterIsNotNull((Object)prefs, (String)"prefs");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        this.prefs = prefs;
        this.name = name;
        this.clazz = clazz;
        this.ttl = ttl;
    }

    public /* synthetic */ SharedPreferencesOptionalDelegate(SharedPreferences sharedPreferences, String string, Class clazz, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            l = -1L;
        }
        this(sharedPreferences, string, clazz, l);
    }
}

