/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.utils;

import android.content.Context;
import android.system.ErrnoException;
import android.system.Os;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import network.path.mobilenode.library.utils.Executable;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnetwork/path/mobilenode/library/utils/Executable;", "", "()V", "EXECUTABLES", "", "", "OVERTURE", "REDSOCKS", "SIMPLE_OBFS", "SS_LOCAL", "SS_TUNNEL", "TUN2SOCKS", "killAll", "", "context", "Landroid/content/Context;", "library_release"})
public final class Executable {
    @NotNull
    public static final String REDSOCKS = "libredsocks.so";
    @NotNull
    public static final String SS_LOCAL = "libss-local.so";
    @NotNull
    public static final String SS_TUNNEL = "libss-tunnel.so";
    @NotNull
    public static final String TUN2SOCKS = "libtun2socks.so";
    @NotNull
    public static final String OVERTURE = "liboverture.so";
    @NotNull
    public static final String SIMPLE_OBFS = "libobfs-local.so";
    private static final Set<String> EXECUTABLES;
    public static final Executable INSTANCE;

    public final void killAll(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        for (File process : new File("/proc").listFiles(killAll.1.INSTANCE)) {
            Object object;
            try {
                object = FilesKt.readText$default((File)new File(process, "cmdline"), null, (int)1, null);
            }
            catch (FileNotFoundException ignore) {
                continue;
            }
            CharSequence charSequence = (CharSequence)object;
            object = new char[]{'\u0000'};
            boolean bl = false;
            int n = 2;
            String string = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)charSequence, (char[])object, (boolean)bl, (int)n, (int)2, null));
            File exe = new File(string);
            if (!Intrinsics.areEqual((Object)exe.getParent(), (Object)context.getApplicationInfo().nativeLibraryDir) || !EXECUTABLES.contains(exe.getName())) continue;
            try {
                File file = process;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"process");
                String string2 = file.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"process.name");
                object = string2;
                Os.kill((int)Integer.parseInt((String)object), (int)9);
            }
            catch (ErrnoException e) {
                if (e.errno == 3) continue;
                StringBuilder stringBuilder = new StringBuilder().append("SIGKILL ").append(exe.getAbsolutePath()).append(" (");
                File file = process;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"process");
                Timber.w((String)stringBuilder.append(file.getName()).append(") failed").toString(), (Object[])new Object[0]);
                Timber.w((Throwable)e);
            }
        }
    }

    private Executable() {
    }

    static {
        Executable executable;
        INSTANCE = executable = new Executable();
        EXECUTABLES = SetsKt.setOf((Object[])new String[]{SS_LOCAL, SS_TUNNEL, REDSOCKS, TUN2SOCKS, OVERTURE, SIMPLE_OBFS});
    }
}

