/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.data.android;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import network.path.mobilenode.library.data.android.NetworkMonitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000G\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t*\u0001\u0016\b\u0000\u0018\u00002\u00020\u0001:\u0002 !B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012J\b\u0010\u001b\u001a\u00020\u0019H\u0002J\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012J\u0006\u0010\u001d\u001a\u00020\u0019J\u0006\u0010\u001e\u001a\u00020\u0019J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017\u00a8\u0006\""}, d2={"Lnetwork/path/mobilenode/library/data/android/NetworkMonitor;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "connectivityManager", "Landroid/net/ConnectivityManager;", "getConnectivityManager", "()Landroid/net/ConnectivityManager;", "intentFilter", "Landroid/content/IntentFilter;", "isConnected", "", "()Z", "setConnected", "(Z)V", "listeners", "", "Lnetwork/path/mobilenode/library/data/android/NetworkMonitor$Listener;", "networkCallback", "Landroid/net/ConnectivityManager$NetworkCallback;", "networkReceiver", "network/path/mobilenode/library/data/android/NetworkMonitor$networkReceiver$1", "Lnetwork/path/mobilenode/library/data/android/NetworkMonitor$networkReceiver$1;", "addListener", "", "l", "checkStatus", "removeListener", "start", "stop", "updateStatus", "Listener", "NetworkCallback", "library_release"})
public final class NetworkMonitor {
    private boolean isConnected;
    private final IntentFilter intentFilter;
    @NotNull
    private final ConnectivityManager connectivityManager;
    private final networkReceiver.1 networkReceiver;
    private ConnectivityManager.NetworkCallback networkCallback;
    private final List<Listener> listeners;
    private final Context context;

    public final boolean isConnected() {
        return this.isConnected;
    }

    public final void setConnected(boolean bl) {
        this.isConnected = bl;
    }

    @NotNull
    public final ConnectivityManager getConnectivityManager() {
        return this.connectivityManager;
    }

    public final void addListener(@NotNull Listener l) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        this.listeners.add(l);
    }

    public final void removeListener(@NotNull Listener l) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        this.listeners.remove(l);
    }

    public final void start() {
        this.checkStatus();
        if (Build.VERSION.SDK_INT >= 24) {
            ConnectivityManager.NetworkCallback networkCallback = this.networkCallback;
            if (networkCallback == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"networkCallback");
            }
            this.connectivityManager.registerDefaultNetworkCallback(networkCallback);
        } else if (Build.VERSION.SDK_INT >= 21) {
            NetworkRequest.Builder builder = new NetworkRequest.Builder();
            NetworkRequest networkRequest = builder.build();
            ConnectivityManager.NetworkCallback networkCallback = this.networkCallback;
            if (networkCallback == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"networkCallback");
            }
            this.connectivityManager.registerNetworkCallback(networkRequest, networkCallback);
        } else {
            this.context.registerReceiver((BroadcastReceiver)this.networkReceiver, this.intentFilter);
        }
    }

    public final void stop() {
        if (Build.VERSION.SDK_INT >= 21) {
            ConnectivityManager.NetworkCallback networkCallback = this.networkCallback;
            if (networkCallback == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"networkCallback");
            }
            this.connectivityManager.unregisterNetworkCallback(networkCallback);
        } else {
            this.context.unregisterReceiver((BroadcastReceiver)this.networkReceiver);
        }
    }

    private final void checkStatus() {
        NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return;
        }
        NetworkInfo networkInfo2 = networkInfo;
        this.updateStatus(networkInfo2.isConnected());
    }

    private final void updateStatus(boolean isConnected) {
        if (isConnected != this.isConnected) {
            this.isConnected = isConnected;
            Iterable $receiver$iv = this.listeners;
            for (Object element$iv : $receiver$iv) {
                Listener it = (Listener)element$iv;
                it.onStatusChanged(isConnected);
            }
        }
    }

    public NetworkMonitor(@NotNull Context context) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        Object object = this.context.getSystemService("connectivity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        this.connectivityManager = (ConnectivityManager)object;
        this.networkReceiver = new BroadcastReceiver(this){
            final /* synthetic */ NetworkMonitor this$0;

            public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
                NetworkMonitor.access$checkStatus(this.this$0);
            }
            {
                this.this$0 = $outer;
            }
        };
        NetworkMonitor networkMonitor = this;
        networkMonitor.listeners = list = (List)new ArrayList();
        if (Build.VERSION.SDK_INT >= 21) {
            this.networkCallback = new NetworkCallback();
        }
    }

    public static final /* synthetic */ void access$checkStatus(NetworkMonitor $this) {
        $this.checkStatus();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lnetwork/path/mobilenode/library/data/android/NetworkMonitor$Listener;", "", "onStatusChanged", "", "connected", "", "library_release"})
    public static interface Listener {
        public void onStatusChanged(boolean var1);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\b"}, d2={"Lnetwork/path/mobilenode/library/data/android/NetworkMonitor$NetworkCallback;", "Landroid/net/ConnectivityManager$NetworkCallback;", "(Lnetwork/path/mobilenode/library/data/android/NetworkMonitor;)V", "onAvailable", "", "network", "Landroid/net/Network;", "onLost", "library_release"})
    @RequiresApi(value=21)
    public final class NetworkCallback
    extends ConnectivityManager.NetworkCallback {
        public void onAvailable(@Nullable Network network) {
            NetworkMonitor.this.updateStatus(true);
        }

        public void onLost(@Nullable Network network) {
            NetworkMonitor.this.updateStatus(false);
        }
    }
}

