/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.data.runner;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import network.path.mobilenode.library.data.runner.Runner;
import network.path.mobilenode.library.data.runner.RunnerUtilsKt;
import network.path.mobilenode.library.data.runner.TcpRunner;
import network.path.mobilenode.library.data.runner.TimeSource;
import network.path.mobilenode.library.domain.entity.JobRequest;
import network.path.mobilenode.library.domain.entity.JobRequestKt;
import network.path.mobilenode.library.domain.entity.JobResult;
import network.path.mobilenode.library.domain.entity.JobType;
import network.path.mobilenode.library.utils.SocketExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lnetwork/path/mobilenode/library/data/runner/TcpRunner;", "Lnetwork/path/mobilenode/library/data/runner/Runner;", "factory", "Ljavax/net/SocketFactory;", "(Ljavax/net/SocketFactory;)V", "jobType", "Lnetwork/path/mobilenode/library/domain/entity/JobType;", "getJobType", "()Lnetwork/path/mobilenode/library/domain/entity/JobType;", "runJob", "Lnetwork/path/mobilenode/library/domain/entity/JobResult;", "jobRequest", "Lnetwork/path/mobilenode/library/domain/entity/JobRequest;", "timeSource", "Lnetwork/path/mobilenode/library/data/runner/TimeSource;", "runTcpJob", "", "library_release"})
public final class TcpRunner
implements Runner {
    @NotNull
    private final JobType jobType;
    private final SocketFactory factory;

    @Override
    @NotNull
    public JobType getJobType() {
        return this.jobType;
    }

    @Override
    @NotNull
    public JobResult runJob(@NotNull JobRequest jobRequest, @NotNull TimeSource timeSource) {
        Intrinsics.checkParameterIsNotNull((Object)jobRequest, (String)"jobRequest");
        Intrinsics.checkParameterIsNotNull((Object)timeSource, (String)"timeSource");
        return RunnerUtilsKt.computeJobResult(this.getJobType(), jobRequest, timeSource, (Function1<? super JobRequest, String>)((Function1)new Function1<JobRequest, String>(this){
            final /* synthetic */ TcpRunner this$0;

            @NotNull
            public final String invoke(@NotNull JobRequest it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                long timeout$iv = 10000L;
                ExecutorService executor$iv = Executors.newSingleThreadExecutor();
                Future<T> f$iv = executor$iv.submit((Callable)new Callable<String>(this, it){
                    final /* synthetic */ runJob.1 this$0;
                    final /* synthetic */ JobRequest $it$inlined;
                    {
                        this.this$0 = var1_1;
                        this.$it$inlined = jobRequest;
                    }

                    public final String call() {
                        return TcpRunner.access$runTcpJob(this.this$0.this$0, this.$it$inlined);
                    }
                });
                return (String)f$iv.get(timeout$iv, TimeUnit.MILLISECONDS);
            }
            {
                this.this$0 = tcpRunner;
                super(1);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String runTcpJob(JobRequest jobRequest) {
        String string;
        Closeable closeable = this.factory.createSocket();
        Throwable throwable = null;
        try {
            String string2;
            Socket it = (Socket)closeable;
            int port = JobRequestKt.endpointPortOrDefault(jobRequest, 80);
            InetSocketAddress address = new InetSocketAddress(JobRequestKt.getEndpointHost(jobRequest), port);
            it.connect(address, (int)10000L);
            if (jobRequest.getPayload() != null) {
                Socket socket = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)socket, (String)"it");
                socket.setSoTimeout((int)5000L);
                SocketExtensionsKt.writeText(it, jobRequest.getPayload());
                string2 = SocketExtensionsKt.readText(it, 32768);
            } else {
                string2 = "TCP connection established successfully";
            }
            string = string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    public TcpRunner(@NotNull SocketFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        this.factory = factory;
        this.jobType = JobType.TCP;
    }

    @NotNull
    public static final /* synthetic */ String access$runTcpJob(TcpRunner $this, @NotNull JobRequest jobRequest) {
        return $this.runTcpJob(jobRequest);
    }
}

