/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.data.runner;

import android.content.Context;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import network.path.mobilenode.library.Constants;
import network.path.mobilenode.library.data.runner.Hop;
import network.path.mobilenode.library.data.runner.Runner;
import network.path.mobilenode.library.data.runner.RunnerUtilsKt;
import network.path.mobilenode.library.data.runner.TimeSource;
import network.path.mobilenode.library.data.runner.TraceResult;
import network.path.mobilenode.library.data.runner.TraceRunner;
import network.path.mobilenode.library.domain.entity.JobRequest;
import network.path.mobilenode.library.domain.entity.JobRequestKt;
import network.path.mobilenode.library.domain.entity.JobResult;
import network.path.mobilenode.library.domain.entity.JobType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lnetwork/path/mobilenode/library/data/runner/TraceRunner;", "Lnetwork/path/mobilenode/library/data/runner/Runner;", "context", "Landroid/content/Context;", "gson", "Lcom/google/gson/Gson;", "(Landroid/content/Context;Lcom/google/gson/Gson;)V", "jobType", "Lnetwork/path/mobilenode/library/domain/entity/JobType;", "getJobType", "()Lnetwork/path/mobilenode/library/domain/entity/JobType;", "runJob", "Lnetwork/path/mobilenode/library/domain/entity/JobResult;", "jobRequest", "Lnetwork/path/mobilenode/library/domain/entity/JobRequest;", "timeSource", "Lnetwork/path/mobilenode/library/data/runner/TimeSource;", "runTraceJob", "Lkotlin/Pair;", "", "", "library_release"})
public final class TraceRunner
implements Runner {
    @NotNull
    private final JobType jobType;
    private final Context context;
    private final Gson gson;

    @Override
    @NotNull
    public JobType getJobType() {
        return this.jobType;
    }

    @Override
    @NotNull
    public JobResult runJob(@NotNull JobRequest jobRequest, @NotNull TimeSource timeSource) {
        Intrinsics.checkParameterIsNotNull((Object)jobRequest, (String)"jobRequest");
        Intrinsics.checkParameterIsNotNull((Object)timeSource, (String)"timeSource");
        return RunnerUtilsKt.computeJobResult(this.getJobType(), jobRequest, timeSource, (Function1<? super JobRequest, Pair<String, Long>>)((Function1)new Function1<JobRequest, Pair<? extends String, ? extends Long>>(this){
            final /* synthetic */ TraceRunner this$0;

            @NotNull
            public final Pair<String, Long> invoke(@NotNull JobRequest it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                long timeout$iv = Constants.INSTANCE.getTRACEROUTE_JOB_TIMEOUT_MILLIS();
                ExecutorService executor$iv = Executors.newSingleThreadExecutor();
                Future<T> f$iv = executor$iv.submit((Callable)new Callable<Pair<? extends String, ? extends Long>>(this, it){
                    final /* synthetic */ runJob.1 this$0;
                    final /* synthetic */ JobRequest $it$inlined;
                    {
                        this.this$0 = var1_1;
                        this.$it$inlined = jobRequest;
                    }

                    public final Pair<? extends String, ? extends Long> call() {
                        return TraceRunner.access$runTraceJob(this.this$0.this$0, this.$it$inlined);
                    }
                });
                return (Pair)f$iv.get(timeout$iv, TimeUnit.MILLISECONDS);
            }
            {
                this.this$0 = traceRunner;
                super(1);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<String, Long> runTraceJob(JobRequest jobRequest) {
        Object object;
        Reader $receiver$iv;
        String libs = this.context.getApplicationInfo().nativeLibraryDir;
        List cmd = CollectionsKt.listOf((Object[])new String[]{new File(libs, "libtraceroute.so").getAbsolutePath(), "--icmp", "--wait=1,3,10", "-n", "--queries=10", JobRequestKt.getEndpointHost(jobRequest)});
        Process p = new ProcessBuilder(cmd).start();
        StringBuilder sb = new StringBuilder();
        Process process = p;
        Intrinsics.checkExpressionValueIsNotNull((Object)process, (String)"p");
        Closeable closeable = $receiver$iv = (Reader)new BufferedReader(new InputStreamReader(process.getInputStream()));
        int n = 8192;
        closeable = (BufferedReader)closeable;
        Throwable throwable = null;
        try {
            Sequence it;
            BufferedReader it$iv = (BufferedReader)closeable;
            Sequence $receiver$iv2 = it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            for (Object element$iv : $receiver$iv2) {
                String line = (String)element$iv;
                sb.append(line);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        p.destroy();
        TraceResult result2 = (TraceResult)this.gson.fromJson(sb.toString(), TraceResult.class);
        return TuplesKt.to((Object)sb.toString(), (object = (Hop)CollectionsKt.lastOrNull(result2.getHops())) != null && (object = ((Hop)object).getRtts()) != null ? Long.valueOf((long)CollectionsKt.averageOfDouble((Iterable)((Iterable)object))) : null);
    }

    public TraceRunner(@NotNull Context context, @NotNull Gson gson) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)gson, (String)"gson");
        this.context = context;
        this.gson = gson;
        this.jobType = JobType.TRACEROUTE;
    }

    @NotNull
    public static final /* synthetic */ Pair access$runTraceJob(TraceRunner $this, @NotNull JobRequest jobRequest) {
        return $this.runTraceJob(jobRequest);
    }
}

