/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.data.android;

import android.annotation.SuppressLint;
import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.Task;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import network.path.mobilenode.library.data.android.LastLocationProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\u0013\b\u0000\u0018\u0000 %2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001%B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u0004\u0018\u00010\rJ\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010 \u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010!H\u0016J\u0006\u0010\"\u001a\u00020\u0017J\u0006\u0010#\u001a\u00020\u0017J\b\u0010$\u001a\u00020\u0017H\u0003R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006&"}, d2={"Lnetwork/path/mobilenode/library/data/android/LastLocationProvider;", "Lcom/google/android/gms/location/LocationCallback;", "Lcom/google/android/gms/common/api/GoogleApiClient$ConnectionCallbacks;", "Lcom/google/android/gms/common/api/GoogleApiClient$OnConnectionFailedListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "apiClient", "Lcom/google/android/gms/common/api/GoogleApiClient;", "kotlin.jvm.PlatformType", "fusedLocationProvider", "Lcom/google/android/gms/location/FusedLocationProviderClient;", "lastLocation", "Landroid/location/Location;", "lastProvider", "", "locationManager", "Landroid/location/LocationManager;", "oldListener", "network/path/mobilenode/library/data/android/LastLocationProvider$oldListener$1", "Lnetwork/path/mobilenode/library/data/android/LastLocationProvider$oldListener$1;", "location", "onConnected", "", "bundle", "Landroid/os/Bundle;", "onConnectionFailed", "result", "Lcom/google/android/gms/common/ConnectionResult;", "onConnectionSuspended", "i", "", "onLocationResult", "Lcom/google/android/gms/location/LocationResult;", "start", "stop", "updateListener", "Companion", "library_release"})
public final class LastLocationProvider
extends LocationCallback
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private final GoogleApiClient apiClient;
    private final LocationManager locationManager;
    private final FusedLocationProviderClient fusedLocationProvider;
    private Location lastLocation;
    private String lastProvider;
    private final oldListener.1 oldListener;
    private static final long UPDATE_DELAY = 15000L;
    public static final Companion Companion = new Companion(null);

    public final void start() {
        this.apiClient.connect();
        LocationRequest request = LocationRequest.create().setPriority(100).setInterval(60000L).setFastestInterval(5000L);
        try {
            this.fusedLocationProvider.requestLocationUpdates(request, (LocationCallback)this, null);
        }
        catch (SecurityException e) {
            Timber.w((Throwable)e, (String)("LOCATION: cannot request fused provider updates: " + e), (Object[])new Object[0]);
        }
        this.updateListener();
    }

    public final void stop() {
        this.fusedLocationProvider.removeLocationUpdates((LocationCallback)this);
        GoogleApiClient googleApiClient = this.apiClient;
        Intrinsics.checkExpressionValueIsNotNull((Object)googleApiClient, (String)"apiClient");
        if (googleApiClient.isConnected()) {
            this.apiClient.disconnect();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final Location location() {
        try {
            Object object;
            Task task;
            this.fusedLocationProvider.flushLocations();
            FusedLocationProviderClient fusedLocationProviderClient = this.fusedLocationProvider;
            Intrinsics.checkExpressionValueIsNotNull((Object)fusedLocationProviderClient, (String)"fusedLocationProvider");
            Task task2 = task = fusedLocationProviderClient.getLastLocation();
            Intrinsics.checkExpressionValueIsNotNull((Object)task2, (String)"task");
            if (!task2.isComplete()) {
                object = this.lastLocation;
            } else {
                void var3_2;
                Location location = (Location)task.getResult();
                Location location2 = location;
                Timber.d((String)("LOCATION: from provider [" + location + "], mocked: " + (location2 != null ? Boolean.valueOf(location2.isFromMockProvider()) : null)), (Object[])new Object[0]);
                Location location3 = location;
                object = location3 != null && location3.isFromMockProvider() ? null : var3_2;
            }
            Location foundLocation = object;
            Timber.d((String)("LOCATION: found location [" + foundLocation + ']'), (Object[])new Object[0]);
            return foundLocation;
        }
        catch (SecurityException e) {
            Timber.w((Throwable)e, (String)"LOCATION: security exception", (Object[])new Object[0]);
            return null;
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private final void updateListener() {
        Criteria criteria = new Criteria();
        criteria.setAccuracy(2);
        criteria.setAltitudeRequired(false);
        criteria.setBearingRequired(false);
        criteria.setPowerRequirement(1);
        String string = this.locationManager.getBestProvider(criteria, true);
        if (string == null) {
            return;
        }
        String provider = string;
        if (Intrinsics.areEqual((Object)this.lastProvider, (Object)provider) ^ true) {
            try {
                this.locationManager.requestLocationUpdates(provider, UPDATE_DELAY, 0.0f, (LocationListener)this.oldListener);
                this.lastProvider = provider;
                Timber.d((String)("LOCATION: requested updates from [" + provider + ']'), (Object[])new Object[0]);
            }
            catch (Exception e) {
                Timber.w((Throwable)e, (String)("LOCATION: cannot request location manager updates: " + e), (Object[])new Object[0]);
            }
        }
    }

    public void onLocationResult(@Nullable LocationResult result2) {
        LocationResult locationResult = result2;
        this.lastLocation = locationResult != null ? locationResult.getLastLocation() : null;
        LocationResult locationResult2 = result2;
        Timber.d((String)("LOCATION: location result: " + (locationResult2 != null ? locationResult2.getLastLocation() : null)), (Object[])new Object[0]);
    }

    public void onConnected(@Nullable Bundle bundle) {
        Timber.d((String)("LOCATION: connected [" + bundle + ']'), (Object[])new Object[0]);
    }

    public void onConnectionSuspended(int i) {
        Timber.d((String)("LOCATION: connection suspended [" + i + ']'), (Object[])new Object[0]);
    }

    public void onConnectionFailed(@NotNull ConnectionResult result2) {
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        Timber.d((String)("LOCATION: connection failed [" + result2 + ']'), (Object[])new Object[0]);
        if (result2.hasResolution()) {
            Timber.d((String)"LOCATION: problem has resolution", (Object[])new Object[0]);
        }
    }

    public LastLocationProvider(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.apiClient = new GoogleApiClient.Builder(context).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
        Object object = context.getSystemService("location");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.location.LocationManager");
        }
        this.locationManager = (LocationManager)object;
        this.fusedLocationProvider = LocationServices.getFusedLocationProviderClient((Context)context);
        this.oldListener = new LocationListener(this){
            final /* synthetic */ LastLocationProvider this$0;

            public void onStatusChanged(@NotNull String provider, int status, @Nullable Bundle extras) {
                Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
                Timber.d((String)("LOCATION: status changed [" + provider + ", " + status + ", " + extras + ']'), (Object[])new Object[0]);
            }

            public void onProviderEnabled(@NotNull String provider) {
                Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
                Timber.d((String)("LOCATION: provider enabled [" + provider + ']'), (Object[])new Object[0]);
                LastLocationProvider.access$updateListener(this.this$0);
            }

            public void onProviderDisabled(@NotNull String provider) {
                Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
                Timber.d((String)("LOCATION: provider disabled [" + provider + ']'), (Object[])new Object[0]);
                LastLocationProvider.access$updateListener(this.this$0);
            }

            public void onLocationChanged(@Nullable Location location) {
                LastLocationProvider.access$setLastLocation$p(this.this$0, location);
                Timber.d((String)("LOCATION: location changed (old): " + location), (Object[])new Object[0]);
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    static {
        UPDATE_DELAY = 15000L;
    }

    public static final /* synthetic */ void access$updateListener(LastLocationProvider $this) {
        $this.updateListener();
    }

    @Nullable
    public static final /* synthetic */ Location access$getLastLocation$p(LastLocationProvider $this) {
        return $this.lastLocation;
    }

    public static final /* synthetic */ void access$setLastLocation$p(LastLocationProvider $this, @Nullable Location location) {
        $this.lastLocation = location;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnetwork/path/mobilenode/library/data/android/LastLocationProvider$Companion;", "", "()V", "UPDATE_DELAY", "", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

