/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.security.xmldsig;

import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.X509Data;

class X509KeySelector
extends KeySelector {
    private X509Certificate certificate;

    X509KeySelector() {
    }

    @Override
    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        for (XMLStructure info : keyInfo.getContent()) {
            if (!(info instanceof X509Data)) continue;
            X509Data x509Data = (X509Data)info;
            for (Object o : x509Data.getContent()) {
                if (!(o instanceof X509Certificate)) continue;
                this.certificate = (X509Certificate)o;
                final PublicKey key = this.certificate.getPublicKey();
                if (!this.algEquals(method.getAlgorithm(), key.getAlgorithm())) continue;
                return new KeySelectorResult(){

                    @Override
                    public Key getKey() {
                        return key;
                    }
                };
            }
        }
        throw new KeySelectorException("No key found!");
    }

    private boolean algEquals(String algURI, String algName) {
        return algName.equalsIgnoreCase("DSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1") || algName.equalsIgnoreCase("RSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1") || algName.equalsIgnoreCase("RSA") && algURI.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256") || algName.equalsIgnoreCase("RSA") && algURI.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }
}

