/*
 * Decompiled with CFR 0.152.
 */
package network.minter.profile.models;

import network.minter.core.crypto.HashUtil;
import org.parceler.Parcel;

@Parcel
public class LoginData {
    public String username;
    public String password;
    public transient String rawPassword;

    public LoginData() {
    }

    private LoginData(Builder builder) {
        this.username = builder.username;
        this.password = builder.password;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public LoginData preparePassword() {
        this.password = HashUtil.sha256HexDouble((String)this.rawPassword);
        return this;
    }

    public static final class Builder {
        private String username;
        private String password;

        private Builder() {
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public LoginData build() {
            return new LoginData(this);
        }
    }
}

