/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.models;

import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.parceler.Parcel;

public class ExpResult<Result> {
    @SerializedName(value="data")
    public Result result;
    public Object links;
    public Meta meta;
    @SerializedName(value="latest_block_time")
    public Date latestBlockTime;
    public ErrorResult error;

    public static <T> ExpResult<T> copyError(ExpResult<?> expResult) {
        new ExpResult().error = expResult.error;
        return new ExpResult();
    }

    public Meta getMeta() {
        if (this.meta == null) {
            Meta meta;
            Meta meta2 = meta;
            meta = new Meta();
            this.meta = meta2;
        }
        return this.meta;
    }

    public String getMessage() {
        ErrorResult errorResult = ((ExpResult)((Object)errorResult)).error;
        if (errorResult == null) {
            return null;
        }
        return errorResult.message;
    }

    public int getCode() {
        ErrorResult errorResult = ((ExpResult)((Object)errorResult)).error;
        if (errorResult == null) {
            return 0;
        }
        return errorResult.code;
    }

    public boolean isOk() {
        return this.error == null;
    }

    @Parcel
    public static class ErrorResult {
        public int code;
        public String message;
        public Map<String, String> fields;

        public String getMessage() {
            return this.message;
        }

        public int getCode() {
            return this.code;
        }
    }

    @Parcel
    public static class Meta {
        @SerializedName(value="current_page")
        public int currentPage;
        @SerializedName(value="last_page")
        public int lastPage;
        public String path;
        @SerializedName(value="per_page")
        public int perPage;
        public int total;
        public Additional additional;

        @Parcel
        public static class Additional {
            @SerializedName(value="total_delegated_bip_value")
            public BigDecimal delegatedAmount;
        }
    }
}

