/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.repo;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import network.minter.blockchain.models.ExchangeBuyValue;
import network.minter.blockchain.models.ExchangeSellValue;
import network.minter.blockchain.models.TransactionCommissionValue;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.blockchain.models.operational.TransactionSign;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import network.minter.explorer.api.GateEstimateEndpoint;
import network.minter.explorer.models.GateResult;
import network.minter.explorer.models.TxCount;
import retrofit2.Call;

public class GateEstimateRepository
extends DataRepository<GateEstimateEndpoint> {
    public GateEstimateRepository(@Nonnull ApiService.Builder apiBuilder) {
        super(apiBuilder);
    }

    public Call<GateResult<ExchangeSellValue>> getCoinExchangeCurrencyToSell(@Nonnull String coinToSell, BigDecimal valueToSell, @Nonnull String coinToBuy) {
        return this.getCoinExchangeCurrencyToSell(coinToSell, valueToSell.multiply(Transaction.VALUE_MUL_DEC).toBigInteger(), coinToBuy);
    }

    public Call<GateResult<ExchangeSellValue>> getCoinExchangeCurrencyToSell(@Nonnull String coinToSell, BigInteger valueToSell, @Nonnull String coinToBuy) {
        return ((GateEstimateEndpoint)this.getInstantService()).getCoinExchangeCurrencyToSell(((String)Preconditions.checkNotNull((Object)coinToSell, (String)"Source coin required")).toUpperCase(), valueToSell.toString(), ((String)Preconditions.checkNotNull((Object)coinToBuy, (String)"Target coin required")).toUpperCase());
    }

    public Call<GateResult<ExchangeBuyValue>> getCoinExchangeCurrencyToBuy(@Nonnull String coinToSell, BigDecimal valueToBuy, @Nonnull String coinToBuy) {
        return this.getCoinExchangeCurrencyToBuy(coinToSell, valueToBuy.multiply(Transaction.VALUE_MUL_DEC).toBigInteger(), coinToBuy);
    }

    public Call<GateResult<ExchangeBuyValue>> getCoinExchangeCurrencyToBuy(@Nonnull String coinToSell, BigInteger valueToBuy, @Nonnull String coinToBuy) {
        return ((GateEstimateEndpoint)this.getInstantService()).getCoinExchangeCurrencyToBuy(((String)Preconditions.checkNotNull((Object)coinToSell, (String)"Source coin required")).toUpperCase(), valueToBuy.toString(), ((String)Preconditions.checkNotNull((Object)coinToBuy, (String)"Target coin required")).toUpperCase());
    }

    public Call<GateResult<TransactionCommissionValue>> getTransactionCommission(TransactionSign sign) {
        Preconditions.checkArgument((sign != null ? 1 : 0) != 0, (Object)"Transaction signature required!");
        return this.getTransactionCommission(sign.getTxSign());
    }

    public Call<GateResult<TransactionCommissionValue>> getTransactionCommission(String sign) {
        Preconditions.checkArgument((sign != null ? 1 : 0) != 0, (Object)"Transaction signature required!");
        return ((GateEstimateEndpoint)this.getInstantService()).getTxCommission(sign);
    }

    public Call<GateResult<TxCount>> getTransactionCount(@Nonnull MinterAddress address) {
        Preconditions.checkArgument((address != null ? 1 : 0) != 0, (Object)"Address can't be null");
        return this.getTransactionCount(address.toString());
    }

    public Call<GateResult<TxCount>> getTransactionCount(@Nonnull String address) {
        return ((GateEstimateEndpoint)this.getInstantService()).getTransactionsCount((String)Preconditions.checkNotNull((Object)address, (String)"Address required!"));
    }

    @Nonnull
    protected Class<GateEstimateEndpoint> getServiceClass() {
        return GateEstimateEndpoint.class;
    }
}

