/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer;

import android.os.Build;
import android.util.Log;
import com.google.gson.GsonBuilder;
import java.math.BigInteger;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterCheck;
import network.minter.core.crypto.MinterHash;
import network.minter.core.crypto.MinterPublicKey;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.api.converters.BigIntegerDeserializer;
import network.minter.core.internal.api.converters.BytesDataDeserializer;
import network.minter.core.internal.api.converters.MinterAddressDeserializer;
import network.minter.core.internal.api.converters.MinterCheckDeserializer;
import network.minter.core.internal.api.converters.MinterHashDeserializer;
import network.minter.core.internal.api.converters.MinterPublicKeyDeserializer;
import network.minter.core.internal.log.Mint;
import network.minter.core.internal.log.StdLogger;
import network.minter.core.internal.log.TimberLogger;
import network.minter.explorer.repo.ExplorerAddressRepository;
import network.minter.explorer.repo.ExplorerCoinsRepository;
import network.minter.explorer.repo.ExplorerTransactionRepository;
import network.minter.explorer.repo.GateGasRepository;
import okhttp3.HttpUrl;
import okhttp3.logging.HttpLoggingInterceptor;

public class MinterExplorerApi {
    public static final String FRONT_URL = "https://testnet.explorer.minter.network";
    public static final String NET_ID_TESTNET = "odin";
    public static final String NET_ID_TESTNET_WITH_MULTISIG = "dva";
    private static final String BASE_API_URL = "https://testnet.explorer.minter.network/api/";
    private static final String BASE_GATE_URL = "https://gate.minter.network/api/";
    private static final String DATE_FORMAT;
    private static MinterExplorerApi INSTANCE;
    private ApiService.Builder mApiService;
    private ApiService.Builder mGateApiService;
    private ExplorerTransactionRepository mTransactionRepository;
    private ExplorerAddressRepository mAddressRepository;
    private ExplorerCoinsRepository mCoinsRepository;
    private GateGasRepository mGasRepository;

    private MinterExplorerApi() {
        this(BASE_API_URL);
    }

    private MinterExplorerApi(String baseApiUrl) {
        this.mApiService = new ApiService.Builder(baseApiUrl, this.getGsonBuilder());
        this.mApiService.addHeader("Content-Type", "application/json");
        this.mApiService.addHeader("X-Minter-Client-Name", "MinterAndroid (explorer)");
        this.mApiService.addHeader("X-Minter-Client-Version", "0.3.1");
        this.mApiService.setDateFormat(DATE_FORMAT);
        this.mGateApiService = new ApiService.Builder(BASE_GATE_URL, this.getGsonBuilder());
        this.mGateApiService.addHeader("Content-Type", "application/json");
        this.mGateApiService.addHeader("X-Minter-Client-Name", "MinterAndroid (gate)");
        this.mGateApiService.addHeader("X-Minter-Client-Version", "0.3.1");
        this.mGateApiService.setDateFormat(DATE_FORMAT);
    }

    public static void initialize() {
        MinterExplorerApi.initialize(false);
    }

    public static void initialize(String baseExplorerApiUrl) {
        MinterExplorerApi.initialize(baseExplorerApiUrl, false);
    }

    public static void initialize(String baseExplorerApiUrl, boolean debug, Mint.Leaf logger) {
        if (INSTANCE != null) {
            return;
        }
        INSTANCE = new MinterExplorerApi(baseExplorerApiUrl);
        MinterExplorerApi.INSTANCE.mApiService.setDebug(debug);
        MinterExplorerApi.INSTANCE.mGateApiService.setDebug(debug);
        if (debug) {
            boolean isAndroid = true;
            try {
                Class.forName("android.util.Log");
                try {
                    Log.d((String)"test", (String)"test");
                }
                catch (RuntimeException e) {
                    isAndroid = false;
                }
            }
            catch (ClassNotFoundException e) {
                isAndroid = false;
            }
            if (!isAndroid && logger instanceof TimberLogger) {
                Mint.brew((Mint.Leaf)new StdLogger());
            } else {
                Mint.brew((Mint.Leaf)logger);
            }
            MinterExplorerApi.INSTANCE.mApiService.setDebugRequestLevel(HttpLoggingInterceptor.Level.BODY);
            MinterExplorerApi.INSTANCE.mGateApiService.setDebugRequestLevel(HttpLoggingInterceptor.Level.BODY);
        }
    }

    public static void initialize(String baseExplorerApiUrl, boolean debug) {
        MinterExplorerApi.initialize(baseExplorerApiUrl, debug, (Mint.Leaf)new TimberLogger());
    }

    public static void initialize(boolean debug) {
        MinterExplorerApi.initialize(BASE_API_URL, debug, (Mint.Leaf)new TimberLogger());
    }

    public static void initialize(boolean debug, Mint.Leaf logger) {
        MinterExplorerApi.initialize(BASE_API_URL, debug, logger);
    }

    public static HttpUrl.Builder newFrontUrl() {
        return HttpUrl.parse((String)FRONT_URL).newBuilder();
    }

    public static MinterExplorerApi getInstance() {
        return INSTANCE;
    }

    public void setNetworkId(String id) {
        this.mApiService.addHeader("X-Minter-Chain-Id", id);
    }

    public GateGasRepository gas() {
        if (this.mGasRepository == null) {
            this.mGasRepository = new GateGasRepository(this.mGateApiService);
        }
        return this.mGasRepository;
    }

    public ExplorerTransactionRepository transactions() {
        if (this.mTransactionRepository == null) {
            this.mTransactionRepository = new ExplorerTransactionRepository(this.mApiService);
        }
        return this.mTransactionRepository;
    }

    public ExplorerCoinsRepository coins() {
        if (this.mCoinsRepository == null) {
            this.mCoinsRepository = new ExplorerCoinsRepository(this.mApiService);
        }
        return this.mCoinsRepository;
    }

    public ApiService.Builder getApiService() {
        return this.mApiService;
    }

    public ApiService.Builder getGateApiService() {
        return this.mGateApiService;
    }

    public ExplorerAddressRepository address() {
        if (this.mAddressRepository == null) {
            this.mAddressRepository = new ExplorerAddressRepository(this.mApiService);
        }
        return this.mAddressRepository;
    }

    public GsonBuilder getGsonBuilder() {
        GsonBuilder out = new GsonBuilder();
        out.setDateFormat(DATE_FORMAT);
        out.registerTypeAdapter(MinterAddress.class, (Object)new MinterAddressDeserializer());
        out.registerTypeAdapter(MinterPublicKey.class, (Object)new MinterPublicKeyDeserializer());
        out.registerTypeAdapter(MinterHash.class, (Object)new MinterHashDeserializer());
        out.registerTypeAdapter(MinterCheck.class, (Object)new MinterCheckDeserializer());
        out.registerTypeAdapter(BigInteger.class, (Object)new BigIntegerDeserializer());
        out.registerTypeAdapter(BytesData.class, (Object)new BytesDataDeserializer());
        return out;
    }

    static {
        String format = "yyyy-MM-dd HH:mm:ssX";
        try {
            Class.forName("android.os.Build");
            if (Build.VERSION.SDK_INT < 24) {
                format = "yyyy-MM-dd HH:mm:ssZ";
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        finally {
            DATE_FORMAT = format;
        }
    }
}

