/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.MinterPublicKey;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.util.RLPBoxed;

public class TxSetHaltBlock
extends Operation {
    public static final Parcelable.Creator<TxSetHaltBlock> CREATOR = new Parcelable.Creator<TxSetHaltBlock>(){

        public TxSetHaltBlock createFromParcel(Parcel parcel) {
            return new TxSetHaltBlock(parcel);
        }

        public TxSetHaltBlock[] newArray(int n) {
            return new TxSetHaltBlock[n];
        }
    };
    private MinterPublicKey mPublicKey;
    private BigInteger mHeight;

    public TxSetHaltBlock() {
    }

    public TxSetHaltBlock(@Nonnull Transaction transaction) {
        super(transaction);
    }

    public TxSetHaltBlock(Parcel parcel) {
        this.mPublicKey = (MinterPublicKey)parcel.readValue(MinterPublicKey.class.getClassLoader());
        this.mHeight = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxSetHaltBlock txSetHaltBlock = this;
        super.writeToParcel(parcel, n);
        parcel.writeValue((Object)txSetHaltBlock.mPublicKey);
        parcel.writeValue((Object)this.mHeight);
    }

    @Override
    public OperationType getType() {
        return OperationType.SetHaltBlock;
    }

    public MinterPublicKey getPublicKey() {
        return this.mPublicKey;
    }

    public TxSetHaltBlock setPublicKey(MinterPublicKey minterPublicKey) {
        this.mPublicKey = minterPublicKey;
        return this;
    }

    public TxSetHaltBlock setPublicKey(CharSequence charSequence) {
        MinterPublicKey minterPublicKey;
        TxSetHaltBlock txSetHaltBlock = txSetHaltBlock2;
        TxSetHaltBlock txSetHaltBlock2 = minterPublicKey;
        minterPublicKey = new MinterPublicKey(charSequence);
        txSetHaltBlock.mPublicKey = txSetHaltBlock2;
        return txSetHaltBlock;
    }

    public BigInteger getHeight() {
        return this.mHeight;
    }

    public TxSetHaltBlock setHeight(long l) {
        if (l >= 1L) {
            this.mHeight = BigInteger.valueOf(l);
            return this;
        }
        throw new IllegalArgumentException("Height must be positive number");
    }

    public TxSetHaltBlock setHeight(BigInteger bigInteger) {
        this.mHeight = bigInteger;
        return this;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        Object object = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        String string = "mPublicKey";
        boolean bl = ((TxSetHaltBlock)((Object)fieldsValidationResult2)).mPublicKey != null;
        TxSetHaltBlock txSetHaltBlock = fieldsValidationResult2;
        FieldsValidationResult fieldsValidationResult2 = ((FieldsValidationResult)object).addResult(string, bl, "Public key must be set");
        object = "mHeight";
        boolean bl2 = txSetHaltBlock.mHeight != null;
        return fieldsValidationResult2.addResult((String)object, bl2, "Block number must be set");
    }

    @Override
    @Nonnull
    protected char[] encodeRLP() {
        return RLPBoxed.encode((Object)new Object[]{this.mPublicKey, this.mHeight});
    }

    @Override
    protected void decodeRLP(@Nonnull char[] objectArray) {
        objectArray = (Object[])RLPBoxed.decode((char[])objectArray, (int)0).getDecoded();
        this.mPublicKey = new MinterPublicKey(this.fromRawRlp(0, objectArray));
        this.mHeight = BytesHelper.fixBigintSignedByte((char[])this.fromRawRlp(1, objectArray));
    }
}

