/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import com.edwardstock.secp256k1.NativeSecp256k1;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import network.minter.blockchain.BuildConfig;
import network.minter.blockchain.models.operational.BlockchainID;
import network.minter.blockchain.models.operational.InvalidEncodedTransactionException;
import network.minter.blockchain.models.operational.SignatureSingleData;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.MinterSDK;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.HashUtil;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterCheck;
import network.minter.core.crypto.PrivateKey;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.util.RLPBoxed;

public class CheckTransaction {
    private static final Object sNativeLock = new Object();
    private String mPassphrase;
    private BytesData mNonce;
    private BlockchainID mChainId;
    private BigInteger mDueBlock;
    private BigInteger mCoinId;
    private BigInteger mValue;
    private BigInteger mGasCoinId;
    private BytesData mLock;
    private SignatureSingleData mSignature;

    CheckTransaction(BytesData bytesData, String string) {
        BigInteger bigInteger = MinterSDK.DEFAULT_COIN_ID;
        v0.mGasCoinId = bigInteger;
        v0.mCoinId = bigInteger;
        v0.mNonce = bytesData;
        v0.mPassphrase = string;
    }

    CheckTransaction() {
        BigInteger bigInteger = MinterSDK.DEFAULT_COIN_ID;
        v0.mGasCoinId = bigInteger;
        v0.mCoinId = bigInteger;
        v0.mNonce = new BytesData("1".getBytes());
    }

    public static boolean validatePassword(MinterCheck minterCheck, String string) {
        return CheckTransaction.validatePassword(minterCheck, string.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean validatePassword(MinterCheck object, byte[] object2) {
        BytesData bytesData;
        NativeSecp256k1.RecoverableSignature recoverableSignature;
        long l;
        object = CheckTransaction.fromEncoded((MinterCheck)object);
        Object object3 = new BytesData(super.encode(true)).sha3Data();
        object2 = new BytesData(object2).sha256Mutable();
        Object object4 = sNativeLock;
        synchronized (object4) {
            l = NativeSecp256k1.contextCreate();
            Object object5 = object2;
            object2 = object3.getBytes();
            recoverableSignature = NativeSecp256k1.signRecoverableSerialized((long)l, (byte[])object2, (byte[])object5.getBytes());
            object2 = recoverableSignature;
            NativeSecp256k1.contextCleanup((long)l);
        }
        object3 = recoverableSignature.v;
        int n = 0;
        boolean bl = recoverableSignature.v[0] != 27;
        Object object6 = object;
        object3[n] = (BytesData)bl;
        object = bytesData;
        bytesData = new BytesData((byte[][])new byte[][]{object2.r, object2.s, (byte[])object3});
        return ((CheckTransaction)object6).getLock().equals(object);
        {
            catch (Throwable throwable) {
                NativeSecp256k1.contextCleanup((long)l);
                throw throwable;
            }
        }
    }

    public static BytesData makeProof(String string, byte[] byArray) {
        return CheckTransaction.makeProof(new MinterAddress((CharSequence)string), byArray);
    }

    public static BytesData makeProof(String string, String string2) {
        return CheckTransaction.makeProof(new MinterAddress((CharSequence)string), string2.getBytes());
    }

    public static BytesData makeProof(MinterAddress minterAddress, String string) {
        return CheckTransaction.makeProof(minterAddress, string.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static BytesData makeProof(MinterAddress object, byte[] object2) {
        BytesData bytesData;
        BytesData bytesData2 = bytesData;
        bytesData = new BytesData(HashUtil.sha256((byte[])object2));
        object = new BytesData(RLPBoxed.encode((Object)new Object[]{object.getData()})).sha3Mutable();
        Object object3 = sNativeLock;
        object2 = object3;
        synchronized (object3) {
            long l = NativeSecp256k1.contextCreate();
            {
                catch (Throwable throwable) {
                    // ** MonitorExit[var1_2 /* !! */ ] (shouldn't be in output)
                    throw throwable;
                }
            }
            BytesData bytesData3 = bytesData2;
            object = object.getBytes();
            object = NativeSecp256k1.signRecoverableSerialized((long)l, (byte[])object, (byte[])bytesData3.getBytes());
            NativeSecp256k1.contextCleanup((long)l);
            // ** MonitorExit[var1_2 /* !! */ ] (shouldn't be in output)
            object2 = object.v;
            int n = 0;
            byte by = object.v[0] == 27 ? (byte)0 : 1;
            object2[n] = by;
            byte[][] byArrayArray = new byte[3][];
            byte[][] byArrayArray2 = byArrayArray;
            byArrayArray2[0] = object.r;
            byArrayArray[1] = object.s;
            byArrayArray[2] = object2;
            return new BytesData((byte[][])byArrayArray2);
            catch (Throwable throwable) {
                NativeSecp256k1.contextCleanup((long)l);
                throw throwable;
            }
        }
    }

    public static CheckTransaction fromEncoded(@Nonnull MinterCheck minterCheck) {
        return CheckTransaction.fromEncoded(minterCheck.toString());
    }

    public static CheckTransaction fromEncoded(@Nonnull String objectArray) {
        Preconditions.checkNotNull((Object)objectArray, (String)"hexEncoded data can't be null");
        Preconditions.checkArgument((objectArray.length() > 0 ? 1 : 0) != 0, (Object)"Encoded transaction is empty");
        objectArray = (Object[])RLPBoxed.decode((char[])new BytesData((BytesData)new MinterCheck((CharSequence)objectArray)).getData(), (int)0).getDecoded();
        if (objectArray.length == 10) {
            CheckTransaction checkTransaction = new CheckTransaction();
            checkTransaction.decodeRLP(objectArray);
            return checkTransaction;
        }
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = objectArray.length;
        throw new InvalidEncodedTransactionException("Encoded transaction has invalid data length: expected 10, given %d", objectArray3);
    }

    private void decodeRLP(Object[] objectArray) {
        CheckTransaction checkTransaction = object;
        ((CheckTransaction)object).mNonce = new BytesData((char[])objectArray[0]);
        ((CheckTransaction)object).mChainId = BlockchainID.valueOf(BytesHelper.fixBigintSignedByte((char[])((CheckTransaction)object).fromRawRlp(1, objectArray)));
        ((CheckTransaction)object).mDueBlock = BytesHelper.fixBigintSignedByte((Object)objectArray[2]);
        ((CheckTransaction)object).mCoinId = BytesHelper.fixBigintSignedByte((Object)objectArray[3]);
        ((CheckTransaction)object).mValue = BytesHelper.fixBigintSignedByte((Object)objectArray[4]);
        checkTransaction.mGasCoinId = BytesHelper.fixBigintSignedByte((Object)objectArray[5]);
        checkTransaction.mLock = new BytesData((char[])objectArray[6]);
        ((CheckTransaction)object).mSignature = new SignatureSingleData();
        char[][] cArrayArray = new char[3][];
        Object object = cArrayArray;
        object[0] = (char[])objectArray[7];
        object[1] = (char[])objectArray[8];
        cArrayArray[2] = (char[])objectArray[9];
        ((CheckTransaction)object).mSignature.decodeRaw(cArrayArray);
    }

    private char[] encode(boolean bl) {
        if (bl) {
            Object[] objectArray = new Object[6];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this.mNonce;
            objectArray2[1] = BigInteger.valueOf(this.mChainId.getId());
            objectArray2[2] = this.mDueBlock;
            objectArray2[3] = this.mCoinId;
            objectArray2[4] = this.mValue;
            objectArray[5] = this.mGasCoinId;
            return RLPBoxed.encode((Object)objectArray);
        }
        CheckTransaction checkTransaction = this;
        char[] cArray = checkTransaction.mLock.getData();
        Object[] objectArray = checkTransaction.mSignature;
        if (checkTransaction.mSignature != null && objectArray.getV() != null && this.mSignature.getR() != null && this.mSignature.getS() != null) {
            Object[] objectArray3 = new Object[10];
            objectArray = objectArray3;
            objectArray[0] = this.mNonce;
            objectArray[1] = BigInteger.valueOf(this.mChainId.getId());
            objectArray[2] = this.mDueBlock;
            objectArray[3] = this.mCoinId;
            objectArray[4] = this.mValue;
            objectArray[5] = this.mGasCoinId;
            objectArray[6] = cArray;
            objectArray[7] = this.mSignature.getV().getData();
            objectArray[8] = this.mSignature.getR().getData();
            objectArray3[9] = this.mSignature.getS().getData();
            return RLPBoxed.encode((Object)objectArray3);
        }
        Object[] objectArray4 = new Object[7];
        objectArray = objectArray4;
        objectArray[0] = this.mNonce;
        objectArray[1] = BigInteger.valueOf(this.mChainId.getId());
        objectArray[2] = this.mDueBlock;
        objectArray[3] = this.mCoinId;
        objectArray[4] = this.mValue;
        objectArray4[5] = this.mGasCoinId;
        objectArray4[6] = cArray;
        return RLPBoxed.encode((Object)objectArray4);
    }

    static /* synthetic */ BlockchainID access$002(CheckTransaction checkTransaction, BlockchainID blockchainID) {
        checkTransaction.mChainId = blockchainID;
        return blockchainID;
    }

    static /* synthetic */ BigInteger access$102(CheckTransaction checkTransaction, BigInteger bigInteger) {
        checkTransaction.mCoinId = bigInteger;
        return bigInteger;
    }

    static /* synthetic */ BigInteger access$202(CheckTransaction checkTransaction, BigInteger bigInteger) {
        checkTransaction.mValue = bigInteger;
        return bigInteger;
    }

    static /* synthetic */ BigInteger access$302(CheckTransaction checkTransaction, BigInteger bigInteger) {
        checkTransaction.mDueBlock = bigInteger;
        return bigInteger;
    }

    static /* synthetic */ BigInteger access$402(CheckTransaction checkTransaction, BigInteger bigInteger) {
        checkTransaction.mGasCoinId = bigInteger;
        return bigInteger;
    }

    public void cleanup() {
        CheckTransaction checkTransaction = this;
        checkTransaction.mPassphrase = null;
        checkTransaction.mNonce = null;
        checkTransaction.mDueBlock = null;
        checkTransaction.mCoinId = null;
        checkTransaction.mValue = null;
        checkTransaction.mLock = null;
        checkTransaction.mSignature = null;
    }

    public BigInteger getCoinId() {
        return this.mCoinId;
    }

    public BytesData getNonce() {
        return this.mNonce;
    }

    public BigInteger getNonceNumeric() {
        return new BigInteger(new String(this.mNonce.getData()));
    }

    public BlockchainID getChainId() {
        return this.mChainId;
    }

    public BigInteger getDueBlock() {
        return this.mDueBlock;
    }

    public String getPassphrase() {
        return this.mPassphrase;
    }

    public BigDecimal getValue() {
        return Transaction.humanizeValue(this.mValue);
    }

    public SignatureSingleData getSignature() {
        return this.mSignature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public MinterCheck sign(PrivateKey object) {
        SignatureSingleData signatureSingleData;
        long l;
        long l2;
        Object object2 = new BytesData(((CheckTransaction)((Object)string)).encode(true)).sha3Data();
        Object object3 = new BytesData(((CheckTransaction)((Object)string)).mPassphrase.getBytes()).sha256Mutable();
        Object object4 = sNativeLock;
        synchronized (object4) {
            l2 = NativeSecp256k1.contextCreate();
            BytesData bytesData = object3;
            object2 = object2.getBytes();
            object2 = NativeSecp256k1.signRecoverableSerialized((long)l2, (byte[])object2, (byte[])bytesData.getBytes());
            NativeSecp256k1.contextCleanup((long)l2);
        }
        object3 = object2.v;
        int n = 0;
        boolean bl = object2.v[0] != 27;
        Object object5 = object4;
        object3[n] = (BytesData)bl;
        ((CheckTransaction)((Object)string)).mLock = new BytesData((byte[][])new byte[][]{object2.r, object2.s, (byte[])object3});
        object2 = new BytesData(((CheckTransaction)((Object)string)).encode(false)).sha3Mutable();
        synchronized (object5) {
            l = NativeSecp256k1.contextCreate();
            PrivateKey privateKey = object;
            object = object2.getBytes();
            object = NativeSecp256k1.signRecoverableSerialized((long)l, (byte[])object, (byte[])privateKey.getBytes());
            NativeSecp256k1.contextCleanup((long)l);
        }
        Object object6 = object2 = signatureSingleData;
        object6();
        ((CheckTransaction)((Object)string)).mSignature = object6;
        signatureSingleData.setSign((NativeSecp256k1.RecoverableSignature)object);
        String string = new BytesData(((CheckTransaction)((Object)string)).encode(false)).toHexString("Mc");
        return new MinterCheck((CharSequence)string);
        {
            catch (Throwable throwable) {
                NativeSecp256k1.contextCleanup((long)l);
                throw throwable;
            }
        }
        {
            catch (Throwable throwable) {
                NativeSecp256k1.contextCleanup((long)l2);
                throw throwable;
            }
        }
    }

    public BytesData getLock() {
        return this.mLock;
    }

    public BigInteger getGasCoinId() {
        return this.mGasCoinId;
    }

    char[] fromRawRlp(int n, Object[] objectArray) {
        if (objectArray[n] instanceof String) {
            return ((String)objectArray[n]).toCharArray();
        }
        return (char[])objectArray[n];
    }

    public static final class Builder {
        private final CheckTransaction mCheck;

        public Builder(BigInteger bigInteger, String string) {
            this(new BytesData(bigInteger.toString(10).getBytes()), string);
        }

        public Builder(CharSequence charSequence, String string) {
            this(new BytesData(charSequence.toString().getBytes()), string);
        }

        public Builder(BytesData bytesData, String string) {
            this.mCheck = new CheckTransaction(bytesData, string);
            CheckTransaction.access$002(this.mCheck, BuildConfig.BLOCKCHAIN_ID);
        }

        public Builder setChainId(BlockchainID blockchainID) {
            Builder builder = this;
            Preconditions.checkNotNull((Object)((Object)blockchainID), (String)"chain id is null");
            CheckTransaction.access$002(builder.mCheck, blockchainID);
            return builder;
        }

        public Builder setCoinId(BigInteger bigInteger) {
            Builder builder = this;
            CheckTransaction.access$102(builder.mCheck, bigInteger);
            return builder;
        }

        public Builder setCoinId(long l) {
            Preconditions.checkArgument((l >= 0L ? 1 : 0) != 0, (Object)"Coin ID can't be negative");
            Builder builder = this;
            CheckTransaction.access$102(builder.mCheck, BigInteger.valueOf(l));
            return builder;
        }

        public Builder setValue(BigDecimal bigDecimal) {
            Builder builder = this;
            CheckTransaction.access$202(builder.mCheck, Transaction.normalizeValue(bigDecimal));
            return builder;
        }

        public Builder setValue(CharSequence charSequence) {
            return this.setValue(new BigDecimal(charSequence.toString()));
        }

        public Builder setDueBlock(BigInteger bigInteger) {
            Builder builder = this;
            CheckTransaction.access$302(builder.mCheck, bigInteger);
            return builder;
        }

        public Builder setGasCoinId(BigInteger bigInteger) {
            Builder builder = this;
            CheckTransaction.access$402(builder.mCheck, bigInteger);
            return builder;
        }

        public Builder setGasCoinId(long l) {
            Preconditions.checkArgument((l >= 0L ? 1 : 0) != 0, (Object)"Coin ID can't be negative");
            return this.setGasCoinId(BigInteger.valueOf(l));
        }

        public CheckTransaction build() {
            Builder builder = this;
            Preconditions.checkNotNull((Object)builder.mCheck.mValue, (String)"Value must be set");
            Preconditions.checkNotNull((Object)builder.mCheck.mDueBlock, (String)"Due block must be set");
            Preconditions.checkNotNull((Object)builder.mCheck.mNonce, (String)"Nonce required");
            Preconditions.checkNotNull((Object)builder.mCheck.mPassphrase, (String)"Passphrase required");
            return builder.mCheck;
        }
    }
}

