/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models;

import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import network.minter.blockchain.models.NodeResult;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterPublicKey;
import org.parceler.Parcel;

@Parcel
public class HistoryTransaction
extends NodeResult {
    public BytesData hash;
    @SerializedName(value="raw_tx")
    public BytesData rawTx;
    public Long height;
    public Long index;
    public MinterAddress from;
    public BigInteger nonce;
    public BigInteger gas;
    @SerializedName(value="gas_price")
    public BigInteger gasPrice;
    @SerializedName(value="gas_coin")
    public BigInteger gasCoinId;
    public Type type;
    public TxBaseResult data;
    public String payload;
    public Map<String, String> tags;

    @Parcel
    public static class TxEditCandidateResult
    extends TxBaseResult {
        @SerializedName(value="reward_address")
        public MinterAddress rewardAddress;
        @SerializedName(value="owner_address")
        public MinterAddress ownerAddress;
        @SerializedName(value="pub_key")
        public MinterPublicKey pubKey;
    }

    @Parcel
    public static class TxMultisendResult
    extends TxBaseResult {
        @SerializedName(value="list")
        public List<TxSendCoinResult> items;
    }

    @Parcel
    public static class TxCreateMultisigResult
    extends TxBaseResult {
        public BigInteger threshold;
        public List<BigInteger> weights;
        public List<MinterAddress> addresses;

        public TxCreateMultisigResult() {
            ArrayList arrayList;
            ArrayList arrayList2;
            Object object = arrayList2;
            arrayList2 = new ArrayList();
            v1.weights = object;
            object = arrayList;
            arrayList = new ArrayList();
            v1.addresses = object;
        }
    }

    @Parcel
    public static class TxRedeemCheckResult
    extends TxBaseResult {
        @SerializedName(value="raw_check")
        public String rawCheck;
        public String proof;

        public String getProof() {
            return this.proof;
        }

        public String getRawCheck() {
            return this.rawCheck;
        }
    }

    @Parcel
    public static class TxDelegateUnbondResult
    extends TxBaseResult {
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;
        public String coin;
        public String value;

        public MinterPublicKey getPublicKey() {
            return this.publicKey;
        }

        public BigDecimal getValue() {
            String string = this.value;
            if (string == null || string.isEmpty()) {
                this.value = "0";
            }
            return new BigDecimal(this.value);
        }

        @Deprecated
        public BigDecimal getStake() {
            return this.getValue();
        }

        public String getCoin() {
            String string = ((TxDelegateUnbondResult)((Object)string)).coin;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }
    }

    @Parcel
    public static class TxSetCandidateOnlineOfflineResult
    extends TxBaseResult {
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;

        public MinterPublicKey getPublicKey() {
            return this.publicKey;
        }
    }

    @Parcel
    public static class TxDeclareCandidacyResult
    extends TxBaseResult {
        public MinterAddress address;
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;
        public int commission;
        public String coin;
        public BigInteger stake;

        public MinterAddress getAddress() {
            return this.address;
        }

        public MinterPublicKey getPublicKey() {
            return this.publicKey;
        }

        public int getCommission() {
            return this.commission;
        }

        public String getCoin() {
            String string = ((TxDeclareCandidacyResult)((Object)string)).coin;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public BigDecimal getStake() {
            if (this.stake == null) {
                this.stake = BigInteger.ZERO;
            }
            return Transaction.humanizeValue(this.stake);
        }
    }

    @Parcel
    public static class TxConvertCoinResult
    extends TxBaseResult {
        @SerializedName(value="coin_to_sell")
        public BigInteger coinToSell;
        @SerializedName(value="coin_to_buy")
        public BigInteger coinToBuy;
        @SerializedName(value="value_to_buy")
        public BigInteger valueToBuy;
        @SerializedName(value="value_to_sell")
        public BigInteger valueToSell;
        @SerializedName(value="minimum_value_to_buy")
        public BigInteger minValueToBuy;
        @SerializedName(value="maximum_value_to_sell")
        public BigInteger maxValueToSell;

        public BigDecimal getValueToBuy() {
            if (this.valueToBuy == null) {
                this.valueToBuy = BigInteger.ZERO;
            }
            return Transaction.humanizeValue(this.valueToBuy);
        }

        public BigDecimal getValueToSell() {
            if (this.valueToSell == null) {
                this.valueToSell = BigInteger.ZERO;
            }
            return Transaction.humanizeValue(this.valueToSell);
        }
    }

    @Parcel
    public static class TxCreateCoinResult
    extends TxBaseResult {
        public String name;
        public String symbol;
        @SerializedName(value="initial_amount")
        public BigInteger initialAmount;
        @SerializedName(value="initial_reserve")
        public BigInteger initialReserve;
        @SerializedName(value="constant_reserve_ratio")
        public BigDecimal crr;
        @SerializedName(value="max_supply")
        public BigInteger maxSupply;

        public String getName() {
            return this.name;
        }

        public String getSymbol() {
            String string = ((TxCreateCoinResult)((Object)string)).symbol;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public BigDecimal getInitialAmount() {
            return Transaction.humanizeValue(this.initialAmount);
        }

        public BigDecimal getInitialReserve() {
            return Transaction.humanizeValue(this.initialReserve);
        }

        public BigDecimal getCrr() {
            return this.crr;
        }
    }

    @Parcel
    public static class TxSendCoinResult
    extends TxBaseResult {
        public MinterAddress to;
        public CoinData coin;
        @SerializedName(value="value")
        public BigInteger amount;

        public MinterAddress getTo() {
            return this.to;
        }

        @Deprecated
        public String getCoin() {
            CoinData coinData = ((TxSendCoinResult)((Object)coinData)).coin;
            return coinData != null ? coinData.symbol.toUpperCase() : null;
        }

        public BigDecimal getAmount() {
            return Transaction.humanizeValue(this.amount);
        }
    }

    @Parcel
    public static class CoinData {
        public BigInteger id;
        public String symbol;

        public String getSymbol() {
            String string = ((CoinData)((Object)string)).symbol;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }
    }

    @Parcel
    public static class TxBaseResult {
    }

    public static final class Type
    extends Enum<Type> {
        @SerializedName(value="1")
        public static final /* enum */ Type Send;
        @SerializedName(value="2")
        public static final /* enum */ Type SellCoin;
        @SerializedName(value="3")
        public static final /* enum */ Type SellAllCoins;
        @SerializedName(value="4")
        public static final /* enum */ Type BuyCoin;
        @SerializedName(value="5")
        public static final /* enum */ Type CreateCoin;
        @SerializedName(value="6")
        public static final /* enum */ Type DeclareCandidacy;
        @SerializedName(value="7")
        public static final /* enum */ Type Delegate;
        @SerializedName(value="8")
        public static final /* enum */ Type Unbond;
        @SerializedName(value="9")
        public static final /* enum */ Type RedeemCheck;
        @SerializedName(value="10")
        public static final /* enum */ Type SetCandidateOnline;
        @SerializedName(value="11")
        public static final /* enum */ Type SetCandidateOffline;
        @SerializedName(value="12")
        public static final /* enum */ Type CreateMultisig;
        @SerializedName(value="13")
        public static final /* enum */ Type Multisend;
        @SerializedName(value="14")
        public static final /* enum */ Type EditCandidate;
        private static final /* synthetic */ Type[] $VALUES;
        Class<? extends TxBaseResult> mCls;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }

        private Type(Class<? extends TxBaseResult> clazz) {
            this.mCls = clazz;
        }

        static {
            Type type;
            Type type2;
            Type type3;
            Type type4;
            Type type5;
            Type type6;
            Type type7;
            Type type8;
            Type type9;
            Type type10;
            Type type11;
            Type type12;
            Type type13;
            Type type14;
            Type type15 = type14;
            Send = new Type(TxSendCoinResult.class);
            Type type16 = type13;
            SellCoin = new Type(TxConvertCoinResult.class);
            Type type17 = type12;
            SellAllCoins = new Type(TxConvertCoinResult.class);
            Type type18 = type11;
            BuyCoin = new Type(TxConvertCoinResult.class);
            Type type19 = type10;
            CreateCoin = new Type(TxCreateCoinResult.class);
            Type type20 = type9;
            DeclareCandidacy = new Type(TxDeclareCandidacyResult.class);
            Type type21 = type8;
            Delegate = new Type(TxDelegateUnbondResult.class);
            Type type22 = type7;
            Unbond = new Type(TxDelegateUnbondResult.class);
            Type type23 = type6;
            RedeemCheck = new Type(TxRedeemCheckResult.class);
            Type type24 = type5;
            SetCandidateOnline = new Type(TxSetCandidateOnlineOfflineResult.class);
            Type type25 = type4;
            SetCandidateOffline = new Type(TxSetCandidateOnlineOfflineResult.class);
            Type type26 = type3;
            CreateMultisig = new Type(TxCreateMultisigResult.class);
            Type type27 = type2;
            Multisend = new Type(TxMultisendResult.class);
            Type type28 = type;
            EditCandidate = new Type(TxEditCandidateResult.class);
            $VALUES = new Type[]{type15, type16, type17, type18, type19, type20, type21, type22, type23, type24, type25, type26, type27, type28};
        }

        public Class<? extends TxBaseResult> getOpClass() {
            return this.mCls;
        }
    }
}

