/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models;

import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import network.minter.blockchain.models.Coin;
import network.minter.blockchain.models.NodeResult;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterPublicKey;
import org.parceler.Parcel;

@Parcel
public class Genesis
extends NodeResult {
    @SerializedName(value="genesis_time")
    public String genesisTime;
    @SerializedName(value="chain_id")
    public String chainId;
    @SerializedName(value="consensus_params")
    public ConsensusParams consensusParams;
    @SerializedName(value="app_hash")
    public String appHash;

    @Parcel
    public static class ConsensusParamsValidator {
        @SerializedName(value="public_key_types")
        public List<String> publicKeyTypes;
    }

    @Parcel
    public static class ConsensusParamsEvidence {
        @SerializedName(value="max_age_num_blocks")
        public BigInteger maxAgeNumBlocks;
        @SerializedName(value="max_age_duration")
        public BigInteger maxAgeDuration;
    }

    @Parcel
    public static class ConsensusParamsBlock {
        @SerializedName(value="max_bytes")
        public BigInteger maxBytes;
        @SerializedName(value="max_gas")
        public BigInteger maxGas;
        @SerializedName(value="time_iota_ms")
        public BigInteger timeIotaMs;
    }

    @Parcel
    public static class ConsensusParams {
        public ConsensusParamsBlock block;
        public ConsensusParamsEvidence evidence;
        public ConsensusParamsValidator validator;
    }

    @Parcel
    public static class AppStateCandidateStake {
        @SerializedName(value="coin")
        public BigInteger coinId;
        public BigInteger value;
        @SerializedName(value="bip_value")
        public BigInteger bipValue;
        public MinterAddress owner;
    }

    @Parcel
    public static class AppStateCandidate {
        public long id;
        @SerializedName(value="control_address")
        public MinterAddress controlAddress;
        @SerializedName(value="owner_address")
        public MinterAddress ownerAddress;
        @SerializedName(value="reward_address")
        public MinterAddress rewardAddress;
        public int commission;
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;
        public List<AppStateCandidateStake> stakes;
    }

    @Parcel
    public static class AppStateAccountBalance {
        @SerializedName(value="coin")
        public BigInteger coinId;
        public BigInteger value;

        public BigDecimal getValue() {
            return Transaction.humanizeValue(this.value);
        }
    }

    @Parcel
    public static class AppStateAccount {
        public MinterAddress address;
        public AppStateAccountBalance balance;
        public BigInteger nonce;
    }

    @Parcel
    public static class AppStateCoin
    extends Coin {
        @SerializedName(value="reserve")
        public BigInteger reserveBalance;
        public long version;
    }

    @Parcel
    public static class AppState {
        public List<AppStateAccount> accounts;
        public List<AppStateCandidate> candidates;
        public List<AppStateCoin> coins;
        @SerializedName(value="coins_count")
        public BigInteger coinCount;
    }
}

