/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain;

import com.google.gson.GsonBuilder;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import network.minter.blockchain.repo.NodeAddressRepository;
import network.minter.blockchain.repo.NodeBlockRepository;
import network.minter.blockchain.repo.NodeCoinRepository;
import network.minter.blockchain.repo.NodeEventRepository;
import network.minter.blockchain.repo.NodeStatusRepository;
import network.minter.blockchain.repo.NodeTransactionRepository;
import network.minter.blockchain.repo.NodeValidatorRepository;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterHash;
import network.minter.core.crypto.MinterPublicKey;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.api.converters.BigIntegerJsonConverter;
import network.minter.core.internal.api.converters.BytesDataJsonConverter;
import network.minter.core.internal.api.converters.MinterAddressJsonConverter;
import network.minter.core.internal.api.converters.MinterHashJsonConverter;
import network.minter.core.internal.api.converters.MinterPublicKeyJsonConverter;
import network.minter.core.internal.common.Acceptor;
import network.minter.core.internal.log.Mint;
import network.minter.core.internal.log.TimberLogger;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import retrofit2.CallAdapter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

public class MinterBlockChainSDK {
    private static final String BASE_NODE_URL = "https://node-api.testnet.minter.network/v2/";
    private static MinterBlockChainSDK INSTANCE;
    private final ApiService.Builder mApiService;
    private NodeAddressRepository mAccountRepository;
    private NodeCoinRepository mCoinRepository;
    private NodeTransactionRepository mTransactionRepository;
    private NodeBlockRepository mBlockRepository;
    private NodeValidatorRepository mCandidateRepository;
    private NodeStatusRepository mStatusRepository;
    private NodeEventRepository mEventRepository;

    private MinterBlockChainSDK() {
        this(BASE_NODE_URL);
    }

    private MinterBlockChainSDK(@Nonnull String object) {
        ResponseErrorToResultInterceptor responseErrorToResultInterceptor;
        Acceptor<Retrofit.Builder> acceptor;
        ApiService.Builder builder;
        ApiService.Builder builder2 = builder;
        builder2((String)object, ((MinterBlockChainSDK)((Object)responseErrorToResultInterceptor2)).getGsonBuilder());
        ((MinterBlockChainSDK)((Object)responseErrorToResultInterceptor2)).mApiService = builder2;
        object = acceptor;
        acceptor = new Acceptor<Retrofit.Builder>((MinterBlockChainSDK)((Object)responseErrorToResultInterceptor2)){

            public void accept(Retrofit.Builder builder) {
                builder.addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.createWithScheduler((Scheduler)Schedulers.io()));
            }
        };
        builder.setRetrofitClientConfig((Acceptor)object);
        builder.addHeader("Content-Type", "application/json");
        builder.addHeader("X-Minter-Client-Name", "MinterAndroid");
        builder.addHeader("X-Minter-Client-Version", "1.0.2");
        ResponseErrorToResultInterceptor responseErrorToResultInterceptor2 = responseErrorToResultInterceptor;
        responseErrorToResultInterceptor = new ResponseErrorToResultInterceptor();
        builder.addHttpInterceptor((Interceptor)responseErrorToResultInterceptor2);
    }

    public static void initialize() {
        TimberLogger timberLogger;
        TimberLogger timberLogger2 = timberLogger;
        timberLogger = new TimberLogger();
        MinterBlockChainSDK.initialize(BASE_NODE_URL, false, (Mint.Leaf)timberLogger2);
    }

    public static MinterBlockChainSDK createInstance(String string, boolean bl, Mint.Leaf object) {
        MinterBlockChainSDK minterBlockChainSDK;
        if (bl) {
            Mint.brew((Mint.Leaf)object);
        }
        object = minterBlockChainSDK;
        new MinterBlockChainSDK((String)string).mApiService.setDebug(bl);
        if (bl) {
            object.mApiService.setDebugRequestLevel(HttpLoggingInterceptor.Level.BODY);
        }
        return object;
    }

    public static void initialize(String string, boolean bl, Mint.Leaf leaf) {
        if (INSTANCE != null) {
            return;
        }
        if (bl) {
            Mint.brew((Mint.Leaf)leaf);
        }
        INSTANCE = new MinterBlockChainSDK(string);
        MinterBlockChainSDK.INSTANCE.mApiService.setDebug(bl);
        if (bl) {
            MinterBlockChainSDK.INSTANCE.mApiService.setDebugRequestLevel(HttpLoggingInterceptor.Level.BODY);
        }
    }

    public static void initialize(boolean bl) {
        TimberLogger timberLogger;
        TimberLogger timberLogger2 = timberLogger;
        timberLogger = new TimberLogger();
        MinterBlockChainSDK.initialize(BASE_NODE_URL, bl, (Mint.Leaf)timberLogger2);
    }

    public static void initialize(boolean bl, Mint.Leaf leaf) {
        MinterBlockChainSDK.initialize(BASE_NODE_URL, bl, leaf);
    }

    public static void initialize(String string) {
        TimberLogger timberLogger;
        String string2 = string;
        string = timberLogger;
        timberLogger = new TimberLogger();
        MinterBlockChainSDK.initialize(string2, false, (Mint.Leaf)string);
    }

    public static MinterBlockChainSDK getInstance() {
        MinterBlockChainSDK minterBlockChainSDK = INSTANCE;
        if (minterBlockChainSDK != null) {
            return minterBlockChainSDK;
        }
        throw new IllegalStateException("You forget to call MinterBlockchainApi.initialize");
    }

    public ApiService.Builder getApiService() {
        return this.mApiService;
    }

    public GsonBuilder getGsonBuilder() {
        MinterPublicKeyJsonConverter minterPublicKeyJsonConverter;
        BytesDataJsonConverter bytesDataJsonConverter;
        BigIntegerJsonConverter bigIntegerJsonConverter;
        MinterHashJsonConverter minterHashJsonConverter;
        MinterAddressJsonConverter minterAddressJsonConverter;
        GsonBuilder gsonBuilder = new GsonBuilder();
        MinterBlockChainSDK minterBlockChainSDK = minterAddressJsonConverter;
        minterAddressJsonConverter = new MinterAddressJsonConverter();
        gsonBuilder.registerTypeAdapter(MinterAddress.class, (Object)minterBlockChainSDK);
        minterBlockChainSDK = minterHashJsonConverter;
        minterHashJsonConverter = new MinterHashJsonConverter();
        gsonBuilder.registerTypeAdapter(MinterHash.class, (Object)minterBlockChainSDK);
        minterBlockChainSDK = bigIntegerJsonConverter;
        bigIntegerJsonConverter = new BigIntegerJsonConverter();
        gsonBuilder.registerTypeAdapter(BigInteger.class, (Object)minterBlockChainSDK);
        minterBlockChainSDK = bytesDataJsonConverter;
        bytesDataJsonConverter = new BytesDataJsonConverter();
        gsonBuilder.registerTypeAdapter(BytesData.class, (Object)minterBlockChainSDK);
        minterBlockChainSDK = minterPublicKeyJsonConverter;
        minterPublicKeyJsonConverter = new MinterPublicKeyJsonConverter();
        gsonBuilder.registerTypeAdapter(MinterPublicKey.class, (Object)minterBlockChainSDK);
        return gsonBuilder;
    }

    public NodeEventRepository event() {
        if (this.mEventRepository == null) {
            this.mEventRepository = new NodeEventRepository(this.mApiService);
        }
        return this.mEventRepository;
    }

    public NodeStatusRepository status() {
        if (this.mStatusRepository == null) {
            this.mStatusRepository = new NodeStatusRepository(this.mApiService);
        }
        return this.mStatusRepository;
    }

    public NodeValidatorRepository validator() {
        if (this.mCandidateRepository == null) {
            this.mCandidateRepository = new NodeValidatorRepository(this.mApiService);
        }
        return this.mCandidateRepository;
    }

    public NodeBlockRepository block() {
        if (this.mBlockRepository == null) {
            this.mBlockRepository = new NodeBlockRepository(this.mApiService);
        }
        return this.mBlockRepository;
    }

    public NodeAddressRepository account() {
        if (this.mAccountRepository == null) {
            this.mAccountRepository = new NodeAddressRepository(this.mApiService);
        }
        return this.mAccountRepository;
    }

    public NodeTransactionRepository transactions() {
        if (this.mTransactionRepository == null) {
            this.mTransactionRepository = new NodeTransactionRepository(this.mApiService);
        }
        return this.mTransactionRepository;
    }

    public NodeCoinRepository coin() {
        if (this.mCoinRepository == null) {
            this.mCoinRepository = new NodeCoinRepository(this.mApiService);
        }
        return this.mCoinRepository;
    }

    public static class ResponseErrorToResultInterceptor
    implements Interceptor {
        @NotNull
        public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
            Interceptor.Chain chain2 = chain;
            ResponseErrorToResultInterceptor responseErrorToResultInterceptor = chain2.proceed(chain2.request());
            if (responseErrorToResultInterceptor.body() != null && responseErrorToResultInterceptor.body().contentType() != null && responseErrorToResultInterceptor.body().contentType().toString().toLowerCase().startsWith("application/json")) {
                Response.Builder builder = responseErrorToResultInterceptor.newBuilder();
                builder.code(200);
                return builder.build();
            }
            return responseErrorToResultInterceptor;
        }
    }
}

