package network.minter.blockchain.samples.estimate_coin_buy;

import java.math.BigDecimal;
import java.math.BigInteger;

import io.reactivex.Observable;
import io.reactivex.schedulers.Schedulers;
import network.minter.blockchain.MinterBlockChainSDK;
import network.minter.blockchain.models.ExchangeBuyValue;
import network.minter.blockchain.repo.NodeCoinRepository;

public class get {

    public static void main(String[] args) {
        MinterBlockChainSDK.initialize("https://minter-node-1.testnet.minter.network:8841");

        NodeCoinRepository repository = MinterBlockChainSDK.getInstance().coin();
        Observable<ExchangeBuyValue> request = repository.getCoinExchangeCurrencyToBuyById(
                new BigInteger("0"), // coinId=0
                new BigDecimal("10"),
                new BigInteger("1") // coinId=1
        );


        // for android use RxJava for android and recommended schedulers:
        // request
        //  .observeOn(Schedulers.io)
        //  .subscribeOn(AndroidSchedulers.mainThread())
        //  .subscribe(result -> {}, err -> {})
        request
                .subscribeOn(Schedulers.computation())
                .blockingSubscribe(result -> {
                    // handle result
                }, err -> {
                    // handle error
                });
    }
}
