/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.repo;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import io.reactivex.Observable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import network.minter.blockchain.MinterBlockChainSDK;
import network.minter.blockchain.api.NodeTransactionEndpoint;
import network.minter.blockchain.models.HistoryTransaction;
import network.minter.blockchain.models.HistoryTransactionList;
import network.minter.blockchain.models.TransactionCommissionValue;
import network.minter.blockchain.models.TransactionSendResult;
import network.minter.blockchain.models.UnconfirmedTransactions;
import network.minter.blockchain.models.operational.TransactionSign;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterHash;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;

public class NodeTransactionRepository
extends DataRepository<NodeTransactionEndpoint>
implements DataRepository.Configurator {
    public NodeTransactionRepository(@Nonnull ApiService.Builder builder) {
        super(builder);
    }

    public Observable<HistoryTransactionList> getTransactions(@Nonnull TQuery tQuery) {
        NodeTransactionRepository nodeTransactionRepository = this;
        return ((NodeTransactionEndpoint)nodeTransactionRepository.getInstantService(nodeTransactionRepository)).getTransactions(((TQuery)Preconditions.checkNotNull((Object)tQuery, (String)"Query required")).build());
    }

    public Observable<HistoryTransaction> getTransaction(MinterHash minterHash) {
        return this.getTransaction(minterHash.toString());
    }

    public Observable<TransactionSendResult> sendTransaction(@Nonnull TransactionSign transactionSign) {
        String string = transactionSign.getTxSign();
        if (!string.startsWith("0x")) {
            string = "0x" + string;
        }
        transactionSign.clear();
        return ((NodeTransactionEndpoint)this.getInstantService()).sendTransaction(string);
    }

    public Observable<HistoryTransaction> getTransaction(String string) {
        NodeTransactionRepository nodeTransactionRepository = this;
        return ((NodeTransactionEndpoint)nodeTransactionRepository.getInstantService(nodeTransactionRepository)).getTransaction(string);
    }

    public void configure(ApiService.Builder builder) {
        TransactionSignDeserializer transactionSignDeserializer;
        HistoryTransactionDeserializer historyTransactionDeserializer;
        ApiService.Builder builder2 = builder;
        Object object = historyTransactionDeserializer;
        historyTransactionDeserializer = new HistoryTransactionDeserializer();
        builder2.registerTypeAdapter(HistoryTransaction.class, object);
        object = transactionSignDeserializer;
        transactionSignDeserializer = new TransactionSignDeserializer();
        builder2.registerTypeAdapter(TransactionSign.class, object);
    }

    public Observable<TransactionCommissionValue> getTransactionCommission(TransactionSign transactionSign) {
        return this.getTransactionCommission(transactionSign.getTxSign());
    }

    public Observable<TransactionCommissionValue> getTransactionCommission(String string) {
        Preconditions.checkArgument((string != null && string.length() > 2 ? 1 : 0) != 0, (Object)"Invalid signature");
        if (!string.substring(0, 2).toLowerCase().equals("0x")) {
            return ((NodeTransactionEndpoint)this.getInstantService()).getTxCommission("0x" + string);
        }
        return ((NodeTransactionEndpoint)this.getInstantService()).getTxCommission(string);
    }

    public Observable<UnconfirmedTransactions> getUnconfirmedList() {
        return ((NodeTransactionEndpoint)this.getInstantService()).getUnconfirmed(null);
    }

    public Observable<UnconfirmedTransactions> getUnconfirmedList(int n) {
        return ((NodeTransactionEndpoint)this.getInstantService()).getUnconfirmed(n);
    }

    @Nonnull
    protected Class<NodeTransactionEndpoint> getServiceClass() {
        return NodeTransactionEndpoint.class;
    }

    public static class TQuery {
        private final Map<String, String> mData;

        public TQuery() {
            HashMap hashMap;
            HashMap hashMap2 = hashMap;
            hashMap = new HashMap();
            v1.mData = hashMap2;
        }

        private String normalizeAddress(String string) {
            String string2 = string.substring(0, 2);
            if (!(string2.equals("Mx") || string2.equals("Mx".toLowerCase()) || string2.equals("0x"))) {
                return string;
            }
            return string.substring(2);
        }

        public TQuery setFrom(MinterAddress minterAddress) {
            return this.setFrom(minterAddress.toString());
        }

        public TQuery setTo(MinterAddress minterAddress) {
            return this.setTo(minterAddress.toString());
        }

        public TQuery setTo(String string) {
            TQuery tQuery = this;
            tQuery.mData.put("tags.tx.to", this.normalizeAddress(string));
            return tQuery;
        }

        public TQuery setFrom(String string) {
            TQuery tQuery = this;
            tQuery.mData.put("tags.tx.from", this.normalizeAddress(string));
            return tQuery;
        }

        public TQuery setCustomTag(String string, String string2) {
            TQuery tQuery = this;
            tQuery.mData.put(string, string2);
            return tQuery;
        }

        public String build() {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : this.mData.entrySet()) {
                stringBuilder2.append(entry.getKey()).append("=").append("'").append(entry.getValue()).append("'");
                if (1 >= this.mData.size()) continue;
                stringBuilder2.append('&');
            }
            return stringBuilder2.toString();
        }
    }

    public static final class HistoryTransactionDeserializer
    implements JsonDeserializer<HistoryTransaction> {
        public HistoryTransaction deserialize(JsonElement jsonElement, Type object, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (!jsonElement.isJsonNull() && jsonElement.isJsonObject()) {
                Object[] objectArray = MinterBlockChainSDK.getInstance().getGsonBuilder().create();
                object = (HistoryTransaction)objectArray.fromJson(jsonElement, HistoryTransaction.class);
                if (jsonElement.getAsJsonObject().has("data")) {
                    jsonDeserializationContext = jsonElement.getAsJsonObject().get("data").getAsJsonObject();
                    HistoryTransaction.Type type = ((HistoryTransaction)object).type;
                    if (type != null) {
                        ((HistoryTransaction)object).data = (HistoryTransaction.TxBaseResult)objectArray.fromJson((JsonElement)jsonDeserializationContext, type.getOpClass());
                    } else {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = jsonElement.getAsJsonObject().get("type").getAsString();
                        throw new IllegalStateException(String.format("Unknown transaction type %s", objectArray));
                    }
                }
                return object;
            }
            return null;
        }
    }

    public static final class TransactionSignDeserializer
    implements JsonDeserializer<TransactionSign> {
        public TransactionSign deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (!jsonElement.isJsonNull() && jsonElement.isJsonPrimitive()) {
                String string = jsonElement.getAsString();
                return new TransactionSign(string);
            }
            return null;
        }
    }
}

