package network.minter.blockchain.samples.estimate_tx_commission;

import java.math.BigInteger;

import io.reactivex.Observable;
import io.reactivex.schedulers.Schedulers;
import network.minter.blockchain.MinterBlockChainSDK;
import network.minter.blockchain.models.TransactionCommissionValue;
import network.minter.blockchain.models.operational.BlockchainID;
import network.minter.blockchain.models.operational.OperationInvalidDataException;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.blockchain.models.operational.TransactionSign;
import network.minter.blockchain.repo.NodeTransactionRepository;
import network.minter.core.MinterSDK;
import network.minter.core.crypto.PrivateKey;

public class get {

    public static void main(String[] args) {
        MinterBlockChainSDK.initialize("https://minter-node-1.testnet.minter.network:8841");

        NodeTransactionRepository repository = MinterBlockChainSDK.getInstance().transactions();

        try {
            Transaction tx = new Transaction.Builder(/*nonce value*/ new BigInteger("1"))
                    .setGasCoinId(MinterSDK.DEFAULT_COIN_ID)
                    .setGasPrice(BigInteger.ONE)
                    .setPayloadString("My Payload")
                    .setBlockchainId(BlockchainID.TestNet)
                    .sendCoin()
                    .setCoinId(MinterSDK.DEFAULT_COIN_ID)
                    .setTo("Mx0000000000000000000000000000000000000000")
                    .setValue("1")
                    .build();

            PrivateKey privateKey = PrivateKey.fromMnemonic("abuse abuse abuse abuse abuse abuse abuse abuse abuse abuse abuse abuse");

            TransactionSign transactionSign = tx.signSingle(privateKey);
            if (transactionSign == null) {
                // Something goes wrong while signing transaction, may be private key invalid, or you did forget to call MinterSDK.initialize(), or something else.
                // It's an edge case and in normal usage this situation will never happens with you
                return;
            }

            Observable<TransactionCommissionValue> request = repository.getTransactionCommission(transactionSign);

            // for android use RxJava for android and recommended schedulers:
            // request
            //  .observeOn(Schedulers.io)
            //  .subscribeOn(AndroidSchedulers.mainThread())
            //  .subscribe(result -> {}, err -> {})
            request
                    .subscribeOn(Schedulers.computation())
                    .blockingSubscribe(transactionCommissionValue -> {
                        System.out.println(
                                transactionCommissionValue.getValue()
                        );
                    }, err -> {
                        // handle error
                    });

        } catch (OperationInvalidDataException e) {
            // something goes wrong while creating transaction, check exception message
            e.printStackTrace();
        }
    }
}
