package network.minter.blockchain.samples.estimate_coin_sell;

import java.math.BigDecimal;
import java.math.BigInteger;

import io.reactivex.Observable;
import io.reactivex.schedulers.Schedulers;
import network.minter.blockchain.MinterBlockChainSDK;
import network.minter.blockchain.models.ExchangeSellValue;
import network.minter.blockchain.repo.NodeCoinRepository;
import network.minter.core.MinterSDK;

public class get {

    public static void main(String[] args) {
        MinterBlockChainSDK.initialize("https://minter-node-1.testnet.minter.network:8841");

        NodeCoinRepository repository = MinterBlockChainSDK.getInstance().coin();
        Observable<ExchangeSellValue> request = repository.getCoinExchangeCurrencyToSellById(
                MinterSDK.DEFAULT_COIN_ID,
                new BigDecimal("10"),
                new BigInteger("1"));


        // for android use RxJava for android and recommended schedulers:
        // request
        //  .observeOn(Schedulers.io)
        //  .subscribeOn(AndroidSchedulers.mainThread())
        //  .subscribe(result -> {}, err -> {})
        request
                .subscribeOn(Schedulers.computation())
                .blockingSubscribe(result -> {
                    // handle result
                }, err -> {
                    // handle error
                });
    }
}
