/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.repo;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.reactivex.Observable;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import network.minter.blockchain.MinterBlockChainSDK;
import network.minter.blockchain.api.NodeEventEndpoint;
import network.minter.blockchain.models.EventList;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.data.DataRepository;
import network.minter.core.internal.log.Mint;

public class NodeEventRepository
extends DataRepository<NodeEventEndpoint>
implements DataRepository.Configurator {
    public NodeEventRepository(@Nonnull ApiService.Builder builder) {
        super(builder);
    }

    public Observable<EventList> getEvents(long l) {
        return ((NodeEventEndpoint)this.getInstantService()).getByHeight(String.valueOf(l));
    }

    public Observable<EventList> getEvents(BigInteger bigInteger) {
        return ((NodeEventEndpoint)this.getInstantService()).getByHeight(bigInteger.toString());
    }

    public void configure(ApiService.Builder builder) {
        EventTypeDeserializer eventTypeDeserializer;
        Object object = eventTypeDeserializer;
        eventTypeDeserializer = new EventTypeDeserializer(MinterBlockChainSDK.getInstance().getGsonBuilder());
        builder.registerTypeAdapter(EventList.class, object);
    }

    @Nonnull
    protected Class<NodeEventEndpoint> getServiceClass() {
        return NodeEventEndpoint.class;
    }

    public static final class EventTypeDeserializer
    implements JsonDeserializer<EventList> {
        private final Gson mGson;

        EventTypeDeserializer(GsonBuilder gsonBuilder) {
            this.mGson = gsonBuilder.create();
        }

        public EventList deserialize(JsonElement jsonElement, Type object, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            EventList eventList;
            object = eventList;
            new EventList().events = new ArrayList<EventList.EventItem>(0);
            if (!jsonElement.isJsonNull() && !jsonElement.getAsJsonObject().isJsonNull() && jsonElement.getAsJsonObject().has("events")) {
                jsonElement = jsonElement.getAsJsonObject().get("events").getAsJsonArray();
                for (int i = 0; i < jsonElement.size(); ++i) {
                    Object[] objectArray;
                    Object[] objectArray2 = objectArray;
                    objectArray = new EventList.EventItem();
                    JsonObject jsonObject = jsonElement.get(i).getAsJsonObject();
                    objectArray2.type = EventList.Type.findByName(jsonObject.get("type").getAsString());
                    if (objectArray2.type == null) {
                        Object[] objectArray3 = new Object[1];
                        objectArray2 = objectArray3;
                        objectArray3[0] = jsonObject.get("type").getAsString();
                        Mint.e((String)"Unknown event type: %s", (Object[])objectArray2);
                        continue;
                    }
                    jsonObject = jsonObject.get("value").getAsJsonObject();
                    objectArray2.value = (EventList.BaseEvent)this.mGson.fromJson((JsonElement)jsonObject, objectArray2.type.getCls());
                    ((EventList)object).events.add((EventList.EventItem)objectArray2);
                }
                return object;
            }
            return object;
        }
    }
}

