/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.util.RLPBoxed;

public final class TxCoinSell
extends Operation {
    public static final Parcelable.Creator<TxCoinSell> CREATOR = new Parcelable.Creator<TxCoinSell>(){

        public TxCoinSell createFromParcel(Parcel parcel) {
            return new TxCoinSell(parcel);
        }

        public TxCoinSell[] newArray(int n) {
            return new TxCoinSell[n];
        }
    };
    private BigInteger mCoinToSell;
    private BigInteger mValueToSell;
    private BigInteger mCoinToBuy;
    private BigInteger mMinValueToBuy;

    public TxCoinSell() {
    }

    public TxCoinSell(Transaction transaction) {
        super(transaction);
    }

    protected TxCoinSell(Parcel parcel) {
        super(parcel);
        this.mCoinToSell = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
        this.mValueToSell = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
        this.mCoinToBuy = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
        this.mMinValueToBuy = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxCoinSell txCoinSell = this;
        super.writeToParcel(parcel, n);
        parcel.writeValue((Object)txCoinSell.mCoinToSell);
        parcel.writeValue((Object)this.mValueToSell);
        parcel.writeValue((Object)this.mCoinToBuy);
        parcel.writeValue((Object)this.mMinValueToBuy);
    }

    public BigInteger getCoinIdToSell() {
        return this.mCoinToSell;
    }

    public TxCoinSell setCoinIdToSell(long l) {
        return this.setCoinIdToSell(BigInteger.valueOf(l));
    }

    public TxCoinSell setCoinIdToSell(BigInteger bigInteger) {
        this.mCoinToSell = bigInteger;
        return this;
    }

    public BigInteger getCoinIdToBuy() {
        return this.mCoinToBuy;
    }

    public TxCoinSell setCoinIdToBuy(BigInteger bigInteger) {
        this.mCoinToBuy = bigInteger;
        return this;
    }

    public TxCoinSell setCoinIdToBuy(long l) {
        return this.setCoinIdToBuy(BigInteger.valueOf(l));
    }

    public BigDecimal getMinValueToBuy() {
        return Transaction.humanizeValue(this.mMinValueToBuy);
    }

    public BigInteger getValueToSellBigInteger() {
        return this.mValueToSell;
    }

    public TxCoinSell setMinValueToBuy(BigDecimal bigDecimal) {
        return this.setMinValueToBuy(Transaction.normalizeValue(bigDecimal));
    }

    public TxCoinSell setValueToSell(BigInteger bigInteger) {
        this.mValueToSell = bigInteger;
        return this;
    }

    public TxCoinSell setMinValueToBuy(@Nonnull CharSequence charSequence) {
        return this.setMinValueToBuy(new BigDecimal(charSequence.toString()));
    }

    public BigDecimal getValueToSell() {
        return Transaction.humanizeValue(this.mValueToSell);
    }

    public TxCoinSell setValueToSell(@Nonnull CharSequence charSequence) {
        return this.setValueToSell(new BigDecimal(charSequence.toString()));
    }

    public TxCoinSell setMinValueToBuy(BigInteger bigInteger) {
        this.mMinValueToBuy = bigInteger;
        return this;
    }

    public TxCoinSell setValueToSell(BigDecimal bigDecimal) {
        return this.setValueToSell(Transaction.normalizeValue(bigDecimal));
    }

    @Override
    public OperationType getType() {
        return OperationType.SellCoin;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        Object object = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        String string = "mCoinToBuy";
        boolean bl = ((TxCoinSell)((Object)fieldsValidationResult2)).mCoinToBuy != null;
        object = ((FieldsValidationResult)object).addResult(string, bl, "Coin to buy must be set");
        string = "mCoinToSell";
        bl = ((TxCoinSell)((Object)fieldsValidationResult2)).mCoinToSell != null;
        object = ((FieldsValidationResult)object).addResult(string, bl, "Coin to sell must be set");
        string = "mValueToSell";
        bl = ((TxCoinSell)((Object)fieldsValidationResult2)).mValueToSell != null;
        TxCoinSell txCoinSell = fieldsValidationResult2;
        FieldsValidationResult fieldsValidationResult2 = ((FieldsValidationResult)object).addResult(string, bl, "Value must be set");
        object = "mMinValueToBuy";
        boolean bl2 = txCoinSell.mMinValueToBuy != null;
        return fieldsValidationResult2.addResult((String)object, bl2, "Minimum value to buy must be set");
    }

    @Override
    @Nonnull
    protected char[] encodeRLP() {
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mCoinToSell;
        objectArray2[1] = this.mValueToSell;
        objectArray2[2] = this.mCoinToBuy;
        objectArray[3] = this.mMinValueToBuy;
        return RLPBoxed.encode((Object)objectArray);
    }

    @Override
    protected void decodeRLP(@Nonnull char[] cArray) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = objectArray3;
        Object[] objectArray3 = (Object[])RLPBoxed.decode((char[])cArray, (int)0).getDecoded();
        objectArray2.mCoinToSell = BytesHelper.fixBigintSignedByte((char[])objectArray.fromRawRlp(0, objectArray3));
        objectArray2.mValueToSell = BytesHelper.fixBigintSignedByte((char[])objectArray.fromRawRlp(1, objectArray3));
        objectArray2.mCoinToBuy = BytesHelper.fixBigintSignedByte((char[])objectArray.fromRawRlp(2, objectArray3));
        objectArray2.mMinValueToBuy = BytesHelper.fixBigintSignedByte((char[])objectArray.fromRawRlp(3, objectArray3));
    }
}

