/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.OperationInvalidDataException;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.RLPSerializable;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.common.Preconditions;

public abstract class Operation
extends RLPSerializable
implements Parcelable {
    private final Transaction mTx;

    public Operation() {
        this.mTx = null;
    }

    public Operation(@Nonnull Transaction transaction) {
        this.mTx = transaction;
    }

    protected Operation(Parcel parcel) {
        this.mTx = (Transaction)parcel.readValue(Transaction.class.getClassLoader());
    }

    public Transaction build() throws OperationInvalidDataException {
        Object object = ((Operation)((Object)string)).mTx;
        if (((Operation)((Object)string)).mTx != null) {
            object = object.setData(string);
            FieldsValidationResult fieldsValidationResult = ((Operation)((Object)string)).validate();
            if (fieldsValidationResult == null) {
                fieldsValidationResult = object.validate();
            } else {
                fieldsValidationResult.addResult(object.validate());
            }
            if (fieldsValidationResult != null && !fieldsValidationResult.isValid()) {
                FieldsValidationResult fieldsValidationResult2 = fieldsValidationResult;
                Object[] objectArray = new String[1];
                Object[] objectArray2 = new Object[1];
                object = objectArray2;
                objectArray2[0] = ((Operation)((Object)string)).getType().name();
                objectArray[0] = String.format("Invalid %s operation data", object);
                String string = (String)Preconditions.firstNonNull((Object)fieldsValidationResult2.getTitle(), (Object[])objectArray);
                object = fieldsValidationResult2.getInvalidFieldsMessages();
                Object[] objectArray3 = new Object[2];
                Object[] objectArray4 = objectArray3;
                objectArray3[0] = string;
                objectArray3[1] = object;
                throw new OperationInvalidDataException(String.format("%s\nInvalid fields:\n%s", objectArray4), fieldsValidationResult.getFieldMessageMap());
            }
            return object;
        }
        throw new OperationInvalidDataException("Can't build operation, because transaction isn't passed", Collections.emptyList());
    }

    public abstract OperationType getType();

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeValue((Object)this.mTx);
    }

    @Nullable
    protected abstract FieldsValidationResult validate();

    protected Transaction getTx() {
        return this.mTx;
    }
}

