/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.UnsignedBytesData;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.util.RLPBoxed;

public final class TxRedeemCheck
extends Operation {
    public static final Parcelable.Creator<TxRedeemCheck> CREATOR = new Parcelable.Creator<TxRedeemCheck>(){

        public Object[] newArray(int n) {
            return new TxRedeemCheck[n];
        }

        public Object createFromParcel(Parcel parcel) {
            return new TxRedeemCheck(parcel);
        }
    };
    private static final int PROOF_LENGTH = 65;
    private UnsignedBytesData mRawCheck;
    private UnsignedBytesData mProof;

    public TxRedeemCheck(Transaction transaction) {
        super(transaction);
    }

    protected TxRedeemCheck(Parcel parcel) {
        super(parcel);
        this.mRawCheck = (UnsignedBytesData)parcel.readValue(UnsignedBytesData.class.getClassLoader());
        this.mProof = (UnsignedBytesData)parcel.readValue(UnsignedBytesData.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxRedeemCheck txRedeemCheck = this;
        super.writeToParcel(parcel, n);
        parcel.writeValue((Object)txRedeemCheck.mRawCheck);
        parcel.writeValue((Object)this.mProof);
    }

    public UnsignedBytesData getRawCheck() {
        return this.mRawCheck;
    }

    public TxRedeemCheck setRawCheck(byte[] byArray) {
        this.mRawCheck = new UnsignedBytesData(byArray);
        return this;
    }

    public TxRedeemCheck setRawCheck(UnsignedBytesData unsignedBytesData) {
        this.mRawCheck = unsignedBytesData.clone();
        return this;
    }

    public TxRedeemCheck setRawCheck(String string) {
        this.mRawCheck = new UnsignedBytesData((CharSequence)string);
        return this;
    }

    public UnsignedBytesData getProof() {
        return this.mProof;
    }

    public TxRedeemCheck setProof(byte[] byArray) {
        boolean bl = byArray.length == 65;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = 65;
        Preconditions.checkArgument((boolean)bl, (Object)String.format(Locale.getDefault(), "Proof must coins exact %d bytes", objectArray2));
        objectArray2.mProof = new UnsignedBytesData(byArray);
        return objectArray2;
    }

    public TxRedeemCheck setProof(UnsignedBytesData unsignedBytesData) {
        boolean bl = unsignedBytesData.size() == 65;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = 65;
        Preconditions.checkArgument((boolean)bl, (Object)String.format(Locale.getDefault(), "Proof must coins exact %d bytes", objectArray2));
        objectArray2.mProof = unsignedBytesData.clone();
        return objectArray2;
    }

    public TxRedeemCheck setProof(String string) {
        boolean bl = string.length() == 130;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = 65;
        objectArray[1] = 130;
        Preconditions.checkArgument((boolean)bl, (Object)String.format(Locale.getDefault(), "Proof must coins exact %d bytes (%d hex string len)", objectArray2));
        objectArray2.mProof = new UnsignedBytesData((CharSequence)string);
        return objectArray2;
    }

    @Override
    public OperationType getType() {
        return OperationType.RedeemCheck;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        Object object = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        String string = "mRawCheck";
        boolean bl = objectArray.mRawCheck != null;
        TxRedeemCheck txRedeemCheck = objectArray;
        Object[] objectArray = ((FieldsValidationResult)object).addResult(string, bl, "Check data must be set");
        object = "mProof";
        string = txRedeemCheck.mProof;
        boolean bl2 = string != null && string.size() == 65;
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = 65;
        return objectArray2.addResult((String)object, bl2, String.format(Locale.getDefault(), "Proof data must be set (%d bytes)", objectArray));
    }

    @Override
    @Nonnull
    protected char[] encodeRLP() {
        return RLPBoxed.encode((Object)new Object[]{this.mRawCheck.getData(), this.mProof.getData()});
    }

    @Override
    protected void decodeRLP(@Nonnull char[] objectArray) {
        TxRedeemCheck txRedeemCheck = this;
        objectArray = (Object[])RLPBoxed.decode((char[])objectArray, (int)0).getDecoded();
        txRedeemCheck.mRawCheck = new UnsignedBytesData(this.fromRawRlp(0, objectArray));
        txRedeemCheck.mProof = new UnsignedBytesData(this.fromRawRlp(1, objectArray));
    }
}

