/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import com.edwardstock.secp256k1.NativeSecp256k1;
import javax.annotation.Nonnull;
import network.minter.blockchain.models.operational.SignatureData;
import network.minter.core.crypto.BytesData;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.util.RLP;

public final class SignatureSingleData
extends SignatureData {
    public static final Parcelable.Creator<SignatureSingleData> CREATOR = new Parcelable.Creator<SignatureSingleData>(){

        public SignatureSingleData createFromParcel(Parcel parcel) {
            return new SignatureSingleData(parcel);
        }

        public SignatureSingleData[] newArray(int n) {
            return new SignatureSingleData[n];
        }
    };
    private BytesData mV;
    private BytesData mR;
    private BytesData mS;

    public SignatureSingleData() {
    }

    protected SignatureSingleData(Parcel parcel) {
        this.mV = (BytesData)parcel.readValue(BytesData.class.getClassLoader());
        this.mR = (BytesData)parcel.readValue(BytesData.class.getClassLoader());
        this.mS = (BytesData)parcel.readValue(BytesData.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeValue((Object)this.mV);
        parcel.writeValue((Object)this.mR);
        parcel.writeValue((Object)this.mS);
    }

    public BytesData getR() {
        return this.mR;
    }

    public BytesData getS() {
        return this.mS;
    }

    public BytesData getV() {
        return this.mV;
    }

    protected void setSign(NativeSecp256k1.RecoverableSignature recoverableSignature) {
        SignatureSingleData signatureSingleData = this;
        signatureSingleData.mV = new BytesData(recoverableSignature.v, true);
        signatureSingleData.mR = new BytesData(recoverableSignature.r, true);
        signatureSingleData.mS = new BytesData(recoverableSignature.s, true);
    }

    protected void decodeRaw(byte[][] byArray) {
        SignatureSingleData signatureSingleData = this;
        signatureSingleData.mV = new BytesData(byArray[0]);
        signatureSingleData.mR = new BytesData(byArray[1]);
        signatureSingleData.mS = new BytesData(byArray[2]);
    }

    @Override
    protected void decodeRLP(@Nonnull byte[] objectArray) {
        SignatureSingleData signatureSingleData = this;
        objectArray = (Object[])RLP.decode((byte[])objectArray, (int)0).getDecoded();
        signatureSingleData.mV = new BytesData(this.fromRawRlp(0, objectArray));
        signatureSingleData.mR = new BytesData(this.fromRawRlp(1, objectArray));
        signatureSingleData.mS = new BytesData(this.fromRawRlp(2, objectArray));
    }

    @Override
    @Nonnull
    protected byte[] encodeRLP() {
        SignatureSingleData signatureSingleData = object;
        Object object = signatureSingleData.mV.getData();
        byte[] byArray = BytesHelper.dropFirstZeroes((byte[])signatureSingleData.mR.getData());
        byte[] byArray2 = BytesHelper.dropFirstZeroes((byte[])signatureSingleData.mS.getData());
        return RLP.encode((Object)new Object[]{object, byArray, byArray2});
    }
}

