/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.DecodeResult;
import network.minter.core.util.RLP;

public final class TxCoinSellAll
extends Operation {
    public static final Parcelable.Creator<TxCoinSellAll> CREATOR = new Parcelable.Creator<TxCoinSellAll>(){

        public TxCoinSellAll createFromParcel(Parcel in) {
            return new TxCoinSellAll(in);
        }

        public TxCoinSellAll[] newArray(int size) {
            return new TxCoinSellAll[size];
        }
    };
    private String mCoinToSell;
    private String mCoinToBuy;
    private BigInteger mMinValueToBuy;

    public TxCoinSellAll(Transaction rawTx) {
        super(rawTx);
    }

    protected TxCoinSellAll(Parcel in) {
        super(in);
        this.mCoinToSell = in.readString();
        this.mCoinToBuy = in.readString();
        this.mMinValueToBuy = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mCoinToSell);
        dest.writeString(this.mCoinToBuy);
        dest.writeValue((Object)this.mMinValueToBuy);
    }

    public String getCoinToSell() {
        return this.mCoinToSell.replace("\u0000", "");
    }

    public TxCoinSellAll setCoinToSell(String coin) {
        this.mCoinToSell = StringHelper.strrpad((int)10, (String)coin.toUpperCase());
        return this;
    }

    public String getCoinToBuy() {
        return this.mCoinToBuy.replace("\u0000", "");
    }

    public TxCoinSellAll setCoinToBuy(String coin) {
        this.mCoinToBuy = StringHelper.strrpad((int)10, (String)coin.toUpperCase());
        return this;
    }

    public TxCoinSellAll setMinValueToBuy(BigInteger amount) {
        this.mMinValueToBuy = amount;
        return this;
    }

    public TxCoinSellAll setMinValueToBuy(BigDecimal amount) {
        return this.setMinValueToBuy(amount.multiply(Transaction.VALUE_MUL_DEC).toBigInteger());
    }

    public BigInteger getMinValueToBuyBigInteger() {
        return this.mMinValueToBuy;
    }

    public BigDecimal getMinValueToBuy() {
        return new BigDecimal(this.mMinValueToBuy).divide(Transaction.VALUE_MUL_DEC);
    }

    public TxCoinSellAll setMinValueToBuy(double amount) {
        return this.setMinValueToBuy(new BigDecimal(String.valueOf(amount)));
    }

    public double getMinValueToBuyDouble() {
        return this.getMinValueToBuy().doubleValue();
    }

    @Override
    public OperationType getType() {
        return OperationType.SellAllCoins;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        return new FieldsValidationResult().addResult("mCoinToBuy", this.mCoinToBuy != null && this.mCoinToBuy.length() > 2 && this.mCoinToBuy.length() < 11, "Coin length must be from 3 to 10 chars").addResult("mCoinToSell", this.mCoinToSell != null && this.mCoinToSell.length() > 2 && this.mCoinToSell.length() < 11, "Coin length must be from 3 to 10 chars").addResult("mMinValueToBuy", this.mMinValueToBuy != null, "Minimum value to buy must be set");
    }

    @Override
    @Nonnull
    protected byte[] encodeRLP() {
        return RLP.encode((Object)new Object[]{this.mCoinToSell, this.mCoinToBuy, this.mMinValueToBuy});
    }

    @Override
    protected void decodeRLP(@Nonnull byte[] rlpEncodedData) {
        DecodeResult rlp = RLP.decode((byte[])rlpEncodedData, (int)0);
        Object[] decoded = (Object[])rlp.getDecoded();
        this.mCoinToSell = StringHelper.bytesToString((byte[])this.fromRawRlp(0, decoded));
        this.mCoinToBuy = StringHelper.bytesToString((byte[])this.fromRawRlp(1, decoded));
        this.mMinValueToBuy = BytesHelper.fixBigintSignedByte((byte[])this.fromRawRlp(2, decoded));
    }
}

