/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.repo;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.HashMap;
import javax.annotation.Nonnull;
import network.minter.blockchain.api.BlockChainAccountEndpoint;
import network.minter.blockchain.models.BCResult;
import network.minter.blockchain.models.Balance;
import network.minter.blockchain.models.CountableData;
import network.minter.blockchain.models.TransactionSendResult;
import network.minter.blockchain.models.operational.TransactionSign;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import retrofit2.Call;

public class BlockChainAccountRepository
extends DataRepository<BlockChainAccountEndpoint> {
    public BlockChainAccountRepository(@Nonnull ApiService.Builder apiBuilder) {
        super(apiBuilder);
    }

    public Call<BCResult<Balance>> getBalance(@Nonnull MinterAddress key) {
        Preconditions.checkNotNull((Object)key, (String)"Public key required!");
        return this.getBalance(key.toString());
    }

    public Call<BCResult<Balance>> getBalance(@Nonnull String address) {
        return ((BlockChainAccountEndpoint)this.getInstantService(api -> api.registerTypeAdapter(Balance.class, (Object)new CoinBalanceDeserializer()))).getBalance((String)Preconditions.checkNotNull((Object)address, (String)"Address required!"));
    }

    public Call<BCResult<CountableData>> getTransactionCount(@Nonnull MinterAddress key) {
        Preconditions.checkNotNull((Object)key, (String)"Public key required!");
        return this.getTransactionCount(key.toString());
    }

    public Call<BCResult<CountableData>> getTransactionCount(@Nonnull String address) {
        return ((BlockChainAccountEndpoint)this.getInstantService()).getTransactionCount((String)Preconditions.checkNotNull((Object)address, (String)"Address required!"));
    }

    public Call<BCResult<TransactionSendResult>> sendTransaction(@Nonnull TransactionSign transactionSign) {
        return ((BlockChainAccountEndpoint)this.getInstantService()).sendTransaction(transactionSign.getTxSign());
    }

    @Nonnull
    protected Class<BlockChainAccountEndpoint> getServiceClass() {
        return BlockChainAccountEndpoint.class;
    }

    public static class CoinBalanceDeserializer
    implements JsonDeserializer<Balance> {
        public Balance deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonNull()) {
                return null;
            }
            Balance balance = new Balance();
            JsonObject o = json.getAsJsonObject();
            o = o.get("balance").getAsJsonObject();
            HashMap<String, Balance.CoinBalance> out = new HashMap<String, Balance.CoinBalance>();
            for (String key : o.keySet()) {
                String uKey = key.toUpperCase();
                Balance.CoinBalance b = new Balance.CoinBalance();
                b.balance = new BigInteger(o.get(uKey).getAsString());
                b.coin = uKey;
                out.put(uKey, b);
            }
            balance.coins = out;
            return balance;
        }
    }
}

