/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models;

import com.google.gson.annotations.SerializedName;
import java.math.BigInteger;
import java.util.List;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterPublicKey;
import org.parceler.Parcel;

@Parcel
public class EventList {
    @SerializedName(value="events")
    public List<EventItem> events;

    @Parcel
    public static class SlashEvent
    extends BaseEvent {
        @SerializedName(value="coin")
        public String coin;
    }

    @Parcel
    public static class RewardEvent
    extends BaseEvent {
        @SerializedName(value="role")
        public String role;
    }

    @Parcel
    public static class BaseEvent {
        @SerializedName(value="address")
        public MinterAddress address;
        @SerializedName(value="amount")
        public BigInteger amount;
        @SerializedName(value="validator_pub_key")
        public MinterPublicKey validatorPublicKey;
    }

    @Parcel
    public static class EventItem {
        public Type type;
        public BaseEvent value;

        public <T extends BaseEvent> T getValue() {
            return (T)this.value;
        }
    }

    public static enum Type {
        Reward("minter/RewardEvent", RewardEvent.class),
        Slash("minter/SlashEvent", SlashEvent.class);

        private String mName;
        private Class<? extends BaseEvent> mCls;

        private Type(String name, Class<? extends BaseEvent> cls) {
            this.mName = name;
            this.mCls = cls;
        }

        public static Type findByName(String type) {
            for (Type t : Type.values()) {
                if (!t.getEventName().toLowerCase().equals(type.toLowerCase())) continue;
                return t;
            }
            return null;
        }

        public Class<? extends BaseEvent> getCls() {
            return this.mCls;
        }

        public String getEventName() {
            return this.mName;
        }
    }
}

