/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.DecodeResult;
import network.minter.core.util.RLP;

public final class TxCoinSellAll
extends Operation {
    public static final Parcelable.Creator<TxCoinSellAll> CREATOR = new Parcelable.Creator<TxCoinSellAll>(){

        public TxCoinSellAll createFromParcel(Parcel in) {
            return new TxCoinSellAll(in);
        }

        public TxCoinSellAll[] newArray(int size) {
            return new TxCoinSellAll[size];
        }
    };
    private String mCoinToSell;
    private String mCoinToBuy;

    public TxCoinSellAll(Transaction rawTx) {
        super(rawTx);
    }

    protected TxCoinSellAll(Parcel in) {
        super(in);
        this.mCoinToSell = in.readString();
        this.mCoinToBuy = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mCoinToSell);
        dest.writeString(this.mCoinToBuy);
    }

    public String getCoinToSell() {
        return this.mCoinToSell.replace("\u0000", "");
    }

    public TxCoinSellAll setCoinToSell(String coin) {
        this.mCoinToSell = StringHelper.strrpad((int)10, (String)coin.toUpperCase());
        return this;
    }

    public String getCoinToBuy() {
        return this.mCoinToBuy.replace("\u0000", "");
    }

    public TxCoinSellAll setCoinToBuy(String coin) {
        this.mCoinToBuy = StringHelper.strrpad((int)10, (String)coin.toUpperCase());
        return this;
    }

    @Override
    public OperationType getType() {
        return OperationType.SellAllCoins;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        return new FieldsValidationResult().addResult("mCoinToBuy", this.mCoinToBuy != null && this.mCoinToBuy.length() > 2 && this.mCoinToBuy.length() < 11, "Coin length must be from 3 to 10 chars").addResult("mCoinToSell", this.mCoinToSell != null && this.mCoinToSell.length() > 2 && this.mCoinToSell.length() < 11, "Coin length must be from 3 to 10 chars");
    }

    @Override
    @NonNull
    protected byte[] encodeRLP() {
        return RLP.encode((Object)new Object[]{this.mCoinToSell, this.mCoinToBuy});
    }

    @Override
    protected void decodeRLP(@NonNull byte[] rlpEncodedData) {
        DecodeResult rlp = RLP.decode((byte[])rlpEncodedData, (int)0);
        Object[] decoded = (Object[])rlp.getDecoded();
        this.mCoinToSell = StringHelper.bytesToString((byte[])this.fromRawRlp(0, decoded));
        this.mCoinToBuy = StringHelper.bytesToString((byte[])this.fromRawRlp(1, decoded));
    }
}

