/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.OperationInvalidDataException;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.common.Preconditions;

public abstract class Operation
implements Parcelable {
    private final Transaction mTx;

    public Operation(@NonNull Transaction rawTx) {
        this.mTx = (Transaction)Preconditions.checkNotNull((Object)rawTx, (String)"Transaction must be set");
    }

    protected Operation(Parcel in) {
        this.mTx = (Transaction)in.readValue(Transaction.class.getClassLoader());
    }

    public Transaction build() throws OperationInvalidDataException {
        Transaction tx = this.mTx.setData(this);
        FieldsValidationResult validated = this.validate();
        if (validated == null) {
            validated = tx.validate();
        } else {
            validated.addResult(tx.validate());
        }
        if (validated != null && !validated.isValid()) {
            String title = (String)Preconditions.firstNonNull((Object)validated.getTitle(), (Object[])new String[]{String.format("Invalid %s operation data", this.getType().name())});
            String body = validated.getInvalidFieldsMessages();
            throw new OperationInvalidDataException(String.format("%s\nInvalid fields:\n%s", title, body), validated.getFieldMessageMap());
        }
        return tx;
    }

    public abstract OperationType getType();

    public int describeContents() {
        return 0;
    }

    @CallSuper
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue((Object)this.mTx);
    }

    protected abstract void decodeRLP(@NonNull byte[] var1);

    protected byte[] fromRawRlp(int idx, Object[] raw) {
        return (byte[])raw[idx];
    }

    @Nullable
    protected abstract FieldsValidationResult validate();

    protected Transaction getTx() {
        return this.mTx;
    }

    @NonNull
    protected abstract byte[] encodeRLP();
}

