/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.DecodeResult;
import network.minter.core.util.RLP;

public final class TxCoinSell
extends Operation {
    public static final Parcelable.Creator<TxCoinSell> CREATOR = new Parcelable.Creator<TxCoinSell>(){

        public TxCoinSell createFromParcel(Parcel in) {
            return new TxCoinSell(in);
        }

        public TxCoinSell[] newArray(int size) {
            return new TxCoinSell[size];
        }
    };
    private String mCoinToSell;
    private BigInteger mValueToSell;
    private String mCoinToBuy;

    public TxCoinSell(Transaction rawTx) {
        super(rawTx);
    }

    protected TxCoinSell(Parcel in) {
        super(in);
        this.mCoinToSell = in.readString();
        this.mValueToSell = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
        this.mCoinToBuy = in.readString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mCoinToSell);
        dest.writeValue((Object)this.mValueToSell);
        dest.writeString(this.mCoinToBuy);
    }

    public String getCoinToSell() {
        return this.mCoinToSell.replace("\u0000", "");
    }

    public TxCoinSell setCoinToSell(String coin) {
        this.mCoinToSell = StringHelper.strrpad((int)10, (String)coin.toUpperCase());
        return this;
    }

    public String getCoinToBuy() {
        return this.mCoinToBuy.replace("\u0000", "");
    }

    public TxCoinSell setCoinToBuy(String coin) {
        this.mCoinToBuy = StringHelper.strrpad((int)10, (String)coin.toUpperCase());
        return this;
    }

    public BigInteger getValueBigInteger() {
        return this.mValueToSell;
    }

    public BigDecimal getValueToSell() {
        return Transaction.VALUE_MUL_DEC.divide(new BigDecimal(this.mValueToSell));
    }

    public TxCoinSell setValueToSell(double amount) {
        return this.setValueToSell(new BigDecimal(amount));
    }

    public double getValueToSellDouble() {
        return this.getValueToSell().doubleValue();
    }

    public TxCoinSell setValueToSell(BigInteger amount) {
        this.mValueToSell = amount;
        return this;
    }

    public TxCoinSell setValueToSell(BigDecimal amount) {
        return this.setValueToSell(amount.multiply(Transaction.VALUE_MUL_DEC).toBigInteger());
    }

    @Override
    public OperationType getType() {
        return OperationType.SellCoin;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        return new FieldsValidationResult().addResult("mCoinToBuy", this.mCoinToBuy != null && this.mCoinToBuy.length() > 2 && this.mCoinToBuy.length() < 11, "Coin length must be from 3 to 10 chars").addResult("mCoinToSell", this.mCoinToSell != null && this.mCoinToSell.length() > 2 && this.mCoinToSell.length() < 11, "Coin length must be from 3 to 10 chars").addResult("mValueToSell", this.mValueToSell != null, "Value must be set");
    }

    @Override
    @NonNull
    protected byte[] encodeRLP() {
        return RLP.encode((Object)new Object[]{this.mCoinToSell, this.mValueToSell, this.mCoinToBuy});
    }

    @Override
    protected void decodeRLP(@NonNull byte[] rlpEncodedData) {
        DecodeResult rlp = RLP.decode((byte[])rlpEncodedData, (int)0);
        Object[] decoded = (Object[])rlp.getDecoded();
        this.mCoinToSell = StringHelper.bytesToString((byte[])this.fromRawRlp(0, decoded));
        this.mValueToSell = BytesHelper.fixBigintSignedByte((byte[])this.fromRawRlp(1, decoded));
        this.mCoinToBuy = StringHelper.bytesToString((byte[])this.fromRawRlp(2, decoded));
    }
}

