/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models;

import android.support.v4.util.ObjectsCompat;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Map;
import network.minter.blockchain.models.operational.Transaction;
import org.parceler.Parcel;

@Parcel
public class Balance {
    public Map<String, CoinBalance> coins;

    public CoinBalance get(String coin) {
        return this.coins.get(coin.toUpperCase());
    }

    public BigDecimal getFor(String coin) {
        if (!this.coins.containsKey(coin.toUpperCase())) {
            return new BigDecimal("0");
        }
        return this.coins.get(coin.toUpperCase()).getBalance();
    }

    @Parcel
    public static class CoinBalance {
        public String coin;
        public BigInteger balance;

        public String getCoin() {
            return this.coin;
        }

        public BigDecimal getBalance() {
            return new BigDecimal(this.balance).setScale(18, RoundingMode.UNNECESSARY).divide(Transaction.VALUE_MUL_DEC, 7);
        }

        public int hashCode() {
            return ObjectsCompat.hash((Object[])new Object[]{this.coin, this.balance});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CoinBalance balance1 = (CoinBalance)o;
            return ObjectsCompat.equals((Object)this.coin, (Object)balance1.coin) && ObjectsCompat.equals((Object)this.balance, (Object)balance1.balance);
        }
    }
}

